/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class X509 {
    private static final Logger LOG = LoggerFactory.getLogger(X509.class);
    private static final Pattern CN_PATTERN = Pattern.compile("CN=([0-9]{9})([^0-9].*)?$");
    private static final Pattern SERIALNUMBER_PATTERN = Pattern.compile("SERIALNUMBER=([0-9]{9})", 2);
    private static final JcaX509CertificateConverter JCA_X509_CERTIFICATE_CONVERTER = new JcaX509CertificateConverter().setProvider("BC");

    public static final Optional<String> findOrganisasjonsnummer(X509Certificate certificate) {
        String subjectDnName = certificate.getSubjectDN().getName();
        return X509.find(certificate, cert -> X509.tryFindOrgnr(subjectDnName, SERIALNUMBER_PATTERN), cert -> X509.tryFindOrgnr(subjectDnName, CN_PATTERN)).findFirst();
    }

    @SafeVarargs
    public static final <R> Stream<R> find(X509Certificate certificate, Function<? super X509Certificate, ? extends Optional<R>> ... extractors) {
        return Stream.of(extractors).map(f -> (Optional)f.apply(certificate)).filter(Optional::isPresent).map(Optional::get);
    }

    private static final Optional<String> tryFindOrgnr(CharSequence text, Pattern extractPattern) {
        Optional<String> extracted = Optional.of(text).map(extractPattern::matcher).filter(Matcher::find).map(m -> m.group(1));
        if (!extracted.isPresent()) {
            LOG.trace("Orgnr ikke funnet i '{}' v.h.a. regex '{}'", (Object)text, (Object)extractPattern);
        }
        return extracted;
    }

    public static final X509Certificate getCertificateFromHolder(X509CertificateHolder holder) {
        try {
            return JCA_X509_CERTIFICATE_CONVERTER.getCertificate(holder);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Error retrieving " + X509Certificate.class.getName() + " from BouncyCastle " + X509CertificateHolder.class.getSimpleName() + ". Reason: " + e.getMessage(), e);
        }
    }

    private X509() {
    }
}

