/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.io.IOException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

final class CertHelper {
    static Optional<X509Certificate> findTrustAnchorCert(X509Certificate cert, Set<TrustAnchor> trust) throws SignatureException {
        return CertHelper.findTrustAnchor(cert, trust).map(TrustAnchor::getTrustedCert);
    }

    static Optional<TrustAnchor> findTrustAnchor(X509Certificate cert, Set<TrustAnchor> trustAnchors) throws SignatureException {
        PublicKey trustPublicKey = null;
        X509CertSelector certSelectX509 = new X509CertSelector();
        X500Principal certIssuer = cert.getIssuerX500Principal();
        try {
            certSelectX509.setSubject(certIssuer.getEncoded());
        }
        catch (IOException ex) {
            throw new SignatureException("Cannot set subject search criteria for trust anchor.", ex);
        }
        for (TrustAnchor trust : trustAnchors) {
            block11: {
                if (trust.getTrustedCert() != null) {
                    if (certSelectX509.match(trust.getTrustedCert())) {
                        trustPublicKey = trust.getTrustedCert().getPublicKey();
                    }
                } else if (trust.getCAName() != null && trust.getCAPublicKey() != null) {
                    try {
                        X500Principal caName = new X500Principal(trust.getCAName());
                        if (!certIssuer.equals(caName)) break block11;
                        trustPublicKey = trust.getCAPublicKey();
                    }
                    catch (IllegalArgumentException ex) {
                        continue;
                    }
                }
            }
            if (trustPublicKey == null) continue;
            try {
                cert.verify(trustPublicKey);
                return Optional.of(trust);
            }
            catch (Exception ex) {
                throw new SignatureException("TrustAnchor found but certificate validation failed.", ex);
            }
        }
        return Optional.empty();
    }

    private CertHelper() {
    }
}

