/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import no.digipost.security.cert.CertStatus;
import no.digipost.security.cert.OcspSetting;
import no.digipost.security.cert.OcspSignatureValidator;

public class CertificateValidatorConfig {
    public static final CertificateValidatorConfig MOST_STRICT = new CertificateValidatorConfig(OcspSetting.OCSP_ACTIVATED, EnumSet.of(CertStatus.OK), OcspSignatureValidator.DEFAULT, false);
    private final OcspSetting ocspSetting;
    private final Set<CertStatus> allowedOcspResults;
    final OcspSignatureValidator ocspSignatureValidator;
    final boolean ignoreCustomSigningCertificatesInOcspResponses;
    private static final CertificateValidatorConfig MOST_STRICT_WITH_NO_OCSP = MOST_STRICT.withUnoptimized(OcspSetting.NO_OCSP);

    public boolean is(OcspSetting setting) {
        return this.ocspSetting == setting;
    }

    public boolean allowsOcspResult(CertStatus status) {
        return this.allowedOcspResults.contains((Object)status);
    }

    private CertificateValidatorConfig(OcspSetting ocspSetting, Set<CertStatus> allowedOcspResults, OcspSignatureValidator ocspSignatureValidator, boolean ignoreCustomSigningCertificatesInOcspResponses) {
        this.ocspSetting = ocspSetting;
        this.allowedOcspResults = Collections.unmodifiableSet(allowedOcspResults);
        this.ocspSignatureValidator = ocspSignatureValidator;
        this.ignoreCustomSigningCertificatesInOcspResponses = ignoreCustomSigningCertificatesInOcspResponses;
    }

    public CertificateValidatorConfig with(OcspSetting ocspSetting) {
        if (this == MOST_STRICT && ocspSetting == OcspSetting.NO_OCSP) {
            return MOST_STRICT_WITH_NO_OCSP;
        }
        return this.withUnoptimized(ocspSetting);
    }

    private CertificateValidatorConfig withUnoptimized(OcspSetting ocspSetting) {
        return new CertificateValidatorConfig(ocspSetting, this.allowedOcspResults, this.ocspSignatureValidator, this.ignoreCustomSigningCertificatesInOcspResponses);
    }

    public CertificateValidatorConfig allowOcspResults(CertStatus ... allowedOcspResults) {
        return new CertificateValidatorConfig(this.ocspSetting, EnumSet.of(CertStatus.OK, allowedOcspResults), this.ocspSignatureValidator, this.ignoreCustomSigningCertificatesInOcspResponses);
    }

    CertificateValidatorConfig validateOcspResponseSignatureUsing(OcspSignatureValidator ocspSignatureValidator) {
        return new CertificateValidatorConfig(this.ocspSetting, this.allowedOcspResults, ocspSignatureValidator, this.ignoreCustomSigningCertificatesInOcspResponses);
    }

    CertificateValidatorConfig ignoreCustomSigningCertificatesInOcspResponses() {
        return new CertificateValidatorConfig(this.ocspSetting, this.allowedOcspResults, this.ocspSignatureValidator, true);
    }
}

