/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

@FunctionalInterface
public interface OcspSignatureValidator {
    public static final OcspSignatureValidator DEFAULT = (ocspResponse, issuer) -> {
        ContentVerifierProvider contentVerifierProvider;
        try {
            contentVerifierProvider = new JcaContentVerifierProviderBuilder().build(issuer);
        }
        catch (OperatorCreationException e) {
            throw new OCSPException(e.getMessage(), (Throwable)e);
        }
        return ocspResponse.isSignatureValid(contentVerifierProvider);
    };

    public boolean isValidSignature(BasicOCSPResp var1, X509Certificate var2) throws OCSPException;
}

