/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RevocationReason {
    unspecified(0),
    keyCompromise(1),
    cACompromise(2),
    affiliationChanged(3),
    superseded(4),
    cessationOfOperation(5),
    certificateHold(6),
    unused(7),
    removeFromCRL(8),
    privilegeWithdrawn(9),
    aACompromise(10),
    UNKNOWN(Integer.MIN_VALUE, r -> "unknown reason");

    private static final Map<Integer, RevocationReason> byCode;
    public final int code;
    private final String textualDescription;

    private RevocationReason(int reasonCode) {
        this(reasonCode, r -> r.name() + " (" + r.code + ")");
    }

    private RevocationReason(int reasonCode, Function<RevocationReason, String> textualDescription) {
        this.code = reasonCode;
        this.textualDescription = textualDescription.apply(this);
    }

    public static RevocationReason resolve(int code) {
        return byCode.getOrDefault(code, UNKNOWN);
    }

    public String toString() {
        return this.textualDescription;
    }

    static {
        byCode = Stream.of(RevocationReason.values()).filter(r -> r != UNKNOWN).collect(Collectors.toMap(r -> r.code, r -> r));
    }
}

