/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.ocsp;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Optional;
import no.digipost.security.DigipostSecurity;
import no.digipost.security.DigipostSecurityException;
import no.digipost.security.Sha1Calculator;
import no.digipost.security.ocsp.OcspResult;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcspLookup {
    static final String AUTHORITY_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.1";
    private static final Logger LOG = LoggerFactory.getLogger(OcspLookup.class);
    public final String uri;
    public final CertificateID certificateId;

    public static Optional<OcspLookup> newLookup(X509Certificate certificate, X509Certificate issuer) {
        String ocspResponderUri;
        byte[] authorityInfoAccessValue = certificate.getExtensionValue(AUTHORITY_INFO_ACCESS_OID);
        if (authorityInfoAccessValue == null) {
            return Optional.empty();
        }
        try {
            ocspResponderUri = OcspLookup.extractResponderUri(authorityInfoAccessValue);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to extract OCSP uri from " + DigipostSecurity.describe(certificate), (Throwable)e);
            return Optional.empty();
        }
        try {
            CertificateID certificateId = new CertificateID((DigestCalculator)new Sha1Calculator(), new X509CertificateHolder(issuer.getEncoded()), certificate.getSerialNumber());
            return Optional.of(new OcspLookup(ocspResponderUri, certificateId));
        }
        catch (IOException | CertificateEncodingException | OCSPException e) {
            LOG.warn("Failed to create certificate ID from issuer " + issuer + " and certificate " + DigipostSecurity.describe(certificate), e);
            return Optional.empty();
        }
    }

    private static String extractResponderUri(byte[] authorityInfoAccessValue) {
        try {
            DEROctetString base = (DEROctetString)ASN1Primitive.fromByteArray((byte[])authorityInfoAccessValue);
            DLSequence seq = (DLSequence)ASN1Primitive.fromByteArray((byte[])base.getOctets());
            Enumeration objects = seq.getObjects();
            while (objects.hasMoreElements()) {
                ASN1Encodable id;
                Object elm = objects.nextElement();
                if (!(elm instanceof DLSequence) || !OCSPObjectIdentifiers.id_pkix_ocsp.equals((Object)(id = ((DLSequence)elm).getObjectAt(0)))) continue;
                DERTaggedObject dt = (DERTaggedObject)((DLSequence)elm).getObjectAt(1);
                DEROctetString dos = (DEROctetString)dt.getObjectParser(dt.getTagNo(), true);
                return new String(dos.getOctets());
            }
            throw new DigipostSecurityException("Object identifier " + OCSPObjectIdentifiers.id_pkix_ocsp + " not found");
        }
        catch (IOException e) {
            throw new DigipostSecurityException("Object identifier " + OCSPObjectIdentifiers.id_pkix_ocsp + " not found", e);
        }
    }

    private OcspLookup(String uri, CertificateID certificateId) {
        this.certificateId = certificateId;
        this.uri = uri;
    }

    public OcspResult executeUsing(CloseableHttpClient client) {
        try {
            ByteArrayEntity ocspRequestEntity = new ByteArrayEntity(new OCSPReqBuilder().addRequest(this.certificateId).build().getEncoded());
            HttpUriRequest ocspRequest = RequestBuilder.post().setUri(this.uri).addHeader("Content-Type", "application/ocsp-request").setEntity((HttpEntity)ocspRequestEntity).build();
            return new OcspResult(this.uri, client.execute(ocspRequest));
        }
        catch (IOException | OCSPException e) {
            throw new DigipostSecurityException(e);
        }
    }

    public String toString() {
        return "OCSP-lookup to responder uri " + this.uri;
    }
}

