/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.ocsp;

import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.stream.Stream;
import no.digipost.security.X509;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcspUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OcspUtils.class);
    private static final DLSequence ASN1_OCSP_SIGNING = new DLSequence((ASN1Encodable)new ASN1ObjectIdentifier("1.3.6.1.5.5.7.3.9"));
    private static final ASN1ObjectIdentifier ASN1_EXTENDED_KEY_USAGE = new ASN1ObjectIdentifier("2.5.29.37");

    public static Optional<X509Certificate> findOscpSigningCertificate(BasicOCSPResp basix) {
        if (basix.getCerts() != null && basix.getCerts().length > 0) {
            Optional<X509Certificate> ocspSigningCertificate = Stream.of(basix.getCerts()).filter(cert -> Optional.of(cert).map(X509CertificateHolder::getExtensions).map(exts -> exts.getExtension(ASN1_EXTENDED_KEY_USAGE)).map(Extension::getParsedValue).map(ASN1Encodable::toASN1Primitive).filter(arg_0 -> ((DLSequence)ASN1_OCSP_SIGNING).equals(arg_0)).isPresent()).map(X509::getCertificateFromHolder).findFirst();
            if (!ocspSigningCertificate.isPresent()) {
                LOG.warn("OCSP response contained certificates, but none of them have OCSP signing extended key usage (identifier {})", (Object)ASN1_EXTENDED_KEY_USAGE.getId());
            }
            return ocspSigningCertificate;
        }
        return Optional.empty();
    }

    private OcspUtils() {
    }
}

