/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.types.Appointment;
import no.digipost.api.datatypes.types.Category;
import no.digipost.api.datatypes.types.Residence;

public enum DataTypeIdentifier {
    APPOINTMENT(Appointment.class, "APPT", Appointment.EXAMPLE),
    RESIDENCE(Residence.class, "RESD", Residence.EXAMPLE),
    CATEGORY(Category.class, "CAT", Category.EXAMPLE);

    private final Class<? extends DataType> dataType;
    private final String shortName;
    private final DataType example;
    private static final Map<Class<? extends DataType>, DataTypeIdentifier> byType;
    private static final Map<String, DataTypeIdentifier> byShortName;

    private DataTypeIdentifier(Class<? extends DataType> dataType, String shortName, DataType example) {
        this.dataType = dataType;
        this.shortName = shortName;
        this.example = example;
    }

    public Class<? extends DataType> getDataType() {
        return this.dataType;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static DataTypeIdentifier fromRepresentationType(Class<? extends DataType> representation) {
        return Optional.ofNullable(byType.get(representation)).orElseThrow(() -> new IllegalStateException(String.format("Could not find %s for type %s. All subtypes of %s must have a unique %s.", DataTypeIdentifier.class.getSimpleName(), representation, DataType.class.getSimpleName(), DataTypeIdentifier.class.getSimpleName())));
    }

    public static DataTypeIdentifier fromShortName(String shortName) {
        return Optional.ofNullable(byShortName.get(shortName)).orElseThrow(() -> new IllegalArgumentException("No value for " + DataTypeIdentifier.class.getSimpleName() + " found for shortName " + shortName));
    }

    public DataType getExample() {
        return this.example;
    }

    public static Set<Class<? extends DataType>> getAllClasses() {
        return byType.keySet();
    }

    static {
        byType = Stream.of(DataTypeIdentifier.values()).collect(Collectors.toMap(DataTypeIdentifier::getDataType, Function.identity()));
        byShortName = Stream.of(DataTypeIdentifier.values()).collect(Collectors.toMap(DataTypeIdentifier::getShortName, Function.identity()));
    }
}

