/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.documentation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import no.digipost.api.datatypes.documentation.ComplexType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.documentation.FieldInfo;
import no.digipost.api.datatypes.documentation.FieldType;
import no.digipost.api.datatypes.documentation.SimpleType;

public class DocumentationStructureBuilder {
    public static <T> Stream<ComplexType> buildTypeStructure(Set<Class<? extends T>> classes, Function<Class<? extends T>, T> getExample) {
        return classes.stream().map(DocumentationStructureBuilder.getTypeInfoWithExample(getExample)).sorted();
    }

    private static <T> Function<? super Class<? extends T>, ComplexType> getTypeInfoWithExample(Function<Class<? extends T>, T> getExample) {
        return type -> {
            List<FieldInfo> fieldInfos = DocumentationStructureBuilder.getFieldInfos(type);
            return new ComplexType((Class<?>)type, DocumentationStructureBuilder.getDescription(type), fieldInfos, getExample.apply((Class)type));
        };
    }

    private static List<FieldInfo> getFieldInfos(Class<?> dataType) {
        return Stream.of(dataType.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).map(DocumentationStructureBuilder.getFieldInfo(dataType)).collect(Collectors.toList());
    }

    private static Function<Field, FieldInfo> getFieldInfo(Class<?> parentType) {
        return field -> new FieldInfo(field.getName(), DocumentationStructureBuilder.resolveTypeOfField(parentType, field.getType()), DocumentationStructureBuilder.isMandatory(field), DocumentationStructureBuilder.getDescription(field));
    }

    private static String getDescription(AnnotatedElement element) {
        return Stream.of(element.getAnnotationsByType(Description.class)).map(Description::value).collect(Collectors.joining(System.lineSeparator()));
    }

    private static boolean isMandatory(Field field) {
        boolean requiredXmlElement = Stream.of(field.getAnnotationsByType(XmlElement.class)).anyMatch(XmlElement::required);
        boolean notNull = ((NotNull[])field.getAnnotationsByType(NotNull.class)).length > 0;
        return requiredXmlElement || notNull;
    }

    private static FieldType resolveTypeOfField(Class<?> parentType, Class<?> fieldType) {
        if (fieldType.getPackage().equals(parentType.getPackage())) {
            return new ComplexType(fieldType, DocumentationStructureBuilder.getDescription(fieldType), DocumentationStructureBuilder.getFieldInfos(fieldType), null);
        }
        return new SimpleType(fieldType);
    }
}

