/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.documentation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import no.digipost.api.datatypes.documentation.ComplexType;
import no.digipost.api.datatypes.documentation.FieldInfo;
import no.digipost.api.datatypes.documentation.FieldType;
import no.digipost.api.datatypes.marshalling.DataTypesJsonMapper;

public class MarkdownPrinter {
    private static String LF = System.lineSeparator();
    private static String LLF = LF + LF;
    private final JAXBContext jaxb;
    private final boolean printJsonExamples;

    public MarkdownPrinter(JAXBContext jaxbContext, boolean printJsonExamples) {
        this.jaxb = jaxbContext;
        this.printJsonExamples = printJsonExamples;
    }

    public String print(List<ComplexType> typeInfos) {
        return this.printHeader(typeInfos) + LLF + this.printTypes(typeInfos) + LF;
    }

    private String printTypes(List<ComplexType> typeInfos) {
        return typeInfos.stream().map(this::printTypeOverview).collect(Collectors.joining(LLF));
    }

    private String printHeader(List<ComplexType> typeInfos) {
        return this.heading(2, "Data types") + LLF + "|Type|Description|" + LF + "|----|-----------|" + LF + typeInfos.stream().map(t -> "|" + this.printLink((FieldType)t) + "|" + t.getDescription() + "|").collect(Collectors.joining(LF));
    }

    private String printTypeOverview(ComplexType typeInfo) {
        return this.heading(2, typeInfo.getTypeName()) + LLF + typeInfo.getDescription() + LLF + this.heading(3, "Fields") + LLF + this.printFields(typeInfo.getFields()) + LLF + (this.printJsonExamples ? this.printJsonExample(typeInfo.getExample()) + LLF : "") + this.printXmlExample(typeInfo.getExample());
    }

    private String printXmlExample(Object example) {
        try {
            StringWriter writer = new StringWriter();
            Marshaller marshaller = this.jaxb.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(example, (Writer)writer);
            return this.heading(3, "XML") + LLF + this.code("xml", writer.toString().trim());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private String code(String type, String s) {
        return "```" + type + LF + s + LF + "```";
    }

    private String printJsonExample(Object example) {
        try {
            return this.heading(3, "JSON") + LLF + this.code("json", DataTypesJsonMapper.getMapper().configure(SerializationFeature.INDENT_OUTPUT, true).writeValueAsString(example).trim());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String printTypeInfo(ComplexType type) {
        return this.heading(3, type.getTypeName()) + LLF + this.printFields(type.getFields());
    }

    private String printFields(List<FieldInfo> fields) {
        String subTypes = fields.stream().map(FieldInfo::getType).filter(FieldType::isComplex).map(t -> (ComplexType)t).map(this::printTypeInfo).collect(Collectors.joining(LLF));
        return "|Name|Type|Required|Description|" + LF + "|----|----|--------|-----------|" + LF + fields.stream().map(this::printField).collect(Collectors.joining(LF)) + (subTypes.isEmpty() ? subTypes : LLF + subTypes);
    }

    private String printField(FieldInfo f) {
        String type = f.getType().isComplex() ? this.printLink(f.getType()) : f.getType().getTypeName();
        return "|" + f.getName() + "|" + type + "|" + (f.isMandatory() ? "yes" : "no") + "|" + f.getDescription() + "|";
    }

    private String printLink(FieldType f) {
        return "[" + f.getTypeName() + "](#" + f.getTypeName().toLowerCase().replaceAll(" ", "-") + ")";
    }

    private String heading(int level, String heading) {
        return Stream.generate(() -> "#").limit(level).collect(Collectors.joining()) + " " + heading;
    }
}

