/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class AppointmentAddress {
    @XmlElement(name="street-address")
    @Size(max=100)
    @Description(value="E.g. Storgata 11")
    private final @Size(max=100) String streetAddress;
    @XmlElement(name="postal-code", required=true)
    @NotNull
    @Size(max=10)
    private final @NotNull @Size(max=10) String postalCode;
    @XmlElement(required=true)
    @NotNull
    @Size(max=100)
    private final @NotNull @Size(max=100) String city;

    public AppointmentAddress(String streetAddress, String postalCode, String city) {
        if (!Pattern.matches("\\d{4}", postalCode)) {
            throw new IllegalArgumentException("Postal code must be 4 digits");
        }
        this.streetAddress = streetAddress;
        this.postalCode = postalCode;
        this.city = city;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppointmentAddress)) {
            return false;
        }
        AppointmentAddress other = (AppointmentAddress)o;
        String this$streetAddress = this.getStreetAddress();
        String other$streetAddress = other.getStreetAddress();
        if (this$streetAddress == null ? other$streetAddress != null : !this$streetAddress.equals(other$streetAddress)) {
            return false;
        }
        String this$postalCode = this.getPostalCode();
        String other$postalCode = other.getPostalCode();
        if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        return !(this$city == null ? other$city != null : !this$city.equals(other$city));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $streetAddress = this.getStreetAddress();
        result = result * 59 + ($streetAddress == null ? 43 : $streetAddress.hashCode());
        String $postalCode = this.getPostalCode();
        result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        return result;
    }

    public String toString() {
        return "AppointmentAddress(streetAddress=" + this.getStreetAddress() + ", postalCode=" + this.getPostalCode() + ", city=" + this.getCity() + ")";
    }

    private AppointmentAddress() {
        this.streetAddress = null;
        this.postalCode = null;
        this.city = null;
    }
}

