/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.util.regex.Pattern;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType
public final class Matrikkel {
    @XmlElement(required=true)
    @Valid
    @NotNull
    @Size(max=4)
    private final @Valid @NotNull @Size(max=4) String kommunenummer;
    @XmlElement(required=true)
    @Valid
    @NotNull
    @Size(max=4)
    private final @Valid @NotNull @Size(max=4) String gaardsnummer;
    @XmlElement(required=true)
    @Valid
    @NotNull
    private final String bruksnummer;
    @XmlElement
    @Valid
    private final String festenummer;
    @XmlElement
    @Valid
    private final String seksjonsnummer;

    public Matrikkel(String kommunenummer, String gaardsnummer, String bruksnummer) {
        this(kommunenummer, gaardsnummer, bruksnummer, "0", "0");
    }

    public Matrikkel(String kommunenummer, String gaardsnummer, String bruksnummer, String festenummer, String seksjonsnummer) {
        if (!Pattern.matches("\\d{4}", kommunenummer)) {
            throw new IllegalArgumentException("Kommunenummer must be 4 digits");
        }
        if (!Pattern.matches("\\d+", gaardsnummer)) {
            throw new IllegalArgumentException("Gaardsnummer can only be digits");
        }
        if (!Pattern.matches("\\d+", bruksnummer)) {
            throw new IllegalArgumentException("Bruksnummer can only be digits");
        }
        if (!Pattern.matches("\\d+", festenummer)) {
            throw new IllegalArgumentException("Festenummer can only be digits");
        }
        if (!Pattern.matches("\\d+", seksjonsnummer)) {
            throw new IllegalArgumentException("Seksjonsnummer can only be digits");
        }
        this.kommunenummer = kommunenummer;
        this.gaardsnummer = gaardsnummer;
        this.bruksnummer = bruksnummer;
        this.festenummer = festenummer;
        this.seksjonsnummer = seksjonsnummer;
    }

    public String getKommunenummer() {
        return this.kommunenummer;
    }

    public String getGaardsnummer() {
        return this.gaardsnummer;
    }

    public String getBruksnummer() {
        return this.bruksnummer;
    }

    public String getFestenummer() {
        return this.festenummer;
    }

    public String getSeksjonsnummer() {
        return this.seksjonsnummer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Matrikkel)) {
            return false;
        }
        Matrikkel other = (Matrikkel)o;
        String this$kommunenummer = this.getKommunenummer();
        String other$kommunenummer = other.getKommunenummer();
        if (this$kommunenummer == null ? other$kommunenummer != null : !this$kommunenummer.equals(other$kommunenummer)) {
            return false;
        }
        String this$gaardsnummer = this.getGaardsnummer();
        String other$gaardsnummer = other.getGaardsnummer();
        if (this$gaardsnummer == null ? other$gaardsnummer != null : !this$gaardsnummer.equals(other$gaardsnummer)) {
            return false;
        }
        String this$bruksnummer = this.getBruksnummer();
        String other$bruksnummer = other.getBruksnummer();
        if (this$bruksnummer == null ? other$bruksnummer != null : !this$bruksnummer.equals(other$bruksnummer)) {
            return false;
        }
        String this$festenummer = this.getFestenummer();
        String other$festenummer = other.getFestenummer();
        if (this$festenummer == null ? other$festenummer != null : !this$festenummer.equals(other$festenummer)) {
            return false;
        }
        String this$seksjonsnummer = this.getSeksjonsnummer();
        String other$seksjonsnummer = other.getSeksjonsnummer();
        return !(this$seksjonsnummer == null ? other$seksjonsnummer != null : !this$seksjonsnummer.equals(other$seksjonsnummer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $kommunenummer = this.getKommunenummer();
        result = result * 59 + ($kommunenummer == null ? 43 : $kommunenummer.hashCode());
        String $gaardsnummer = this.getGaardsnummer();
        result = result * 59 + ($gaardsnummer == null ? 43 : $gaardsnummer.hashCode());
        String $bruksnummer = this.getBruksnummer();
        result = result * 59 + ($bruksnummer == null ? 43 : $bruksnummer.hashCode());
        String $festenummer = this.getFestenummer();
        result = result * 59 + ($festenummer == null ? 43 : $festenummer.hashCode());
        String $seksjonsnummer = this.getSeksjonsnummer();
        result = result * 59 + ($seksjonsnummer == null ? 43 : $seksjonsnummer.hashCode());
        return result;
    }

    public String toString() {
        return "Matrikkel(kommunenummer=" + this.getKommunenummer() + ", gaardsnummer=" + this.getGaardsnummer() + ", bruksnummer=" + this.getBruksnummer() + ", festenummer=" + this.getFestenummer() + ", seksjonsnummer=" + this.getSeksjonsnummer() + ")";
    }

    private Matrikkel() {
        this.kommunenummer = null;
        this.gaardsnummer = null;
        this.bruksnummer = null;
        this.festenummer = null;
        this.seksjonsnummer = null;
    }
}

