/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Matrikkel;
import no.digipost.api.datatypes.types.ResidenceAddress;

@XmlRootElement
@Description(value="Residence is a way of linking separate data for the same residence")
public final class Residence
implements DataType {
    @XmlElement(required=true)
    @NotNull
    @Valid
    private final ResidenceAddress address;
    @XmlElement
    @Valid
    private final Matrikkel matrikkel;
    @XmlElement
    @Valid
    @Size(max=50)
    private final @Valid @Size(max=50) String source;
    @XmlElement(name="external-id")
    @Valid
    @Size(max=50)
    private final @Valid @Size(max=50) String externalId;
    public static Residence EXAMPLE = new Residence(new ResidenceAddress("23", "Storgata", "0011", "Oslo"), new Matrikkel("0301", "208", "630", "0", "0"), "boligmappa", "externalId");

    public ResidenceAddress getAddress() {
        return this.address;
    }

    public Matrikkel getMatrikkel() {
        return this.matrikkel;
    }

    public String getSource() {
        return this.source;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Residence)) {
            return false;
        }
        Residence other = (Residence)o;
        ResidenceAddress this$address = this.getAddress();
        ResidenceAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        Matrikkel this$matrikkel = this.getMatrikkel();
        Matrikkel other$matrikkel = other.getMatrikkel();
        if (this$matrikkel == null ? other$matrikkel != null : !((Object)this$matrikkel).equals(other$matrikkel)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResidenceAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        Matrikkel $matrikkel = this.getMatrikkel();
        result = result * 59 + ($matrikkel == null ? 43 : ((Object)$matrikkel).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        return result;
    }

    public String toString() {
        return "Residence(address=" + this.getAddress() + ", matrikkel=" + this.getMatrikkel() + ", source=" + this.getSource() + ", externalId=" + this.getExternalId() + ")";
    }

    @ConstructorProperties(value={"address", "matrikkel", "source", "externalId"})
    public Residence(ResidenceAddress address, Matrikkel matrikkel, String source, String externalId) {
        this.address = address;
        this.matrikkel = matrikkel;
        this.source = source;
        this.externalId = externalId;
    }

    private Residence() {
        this.address = null;
        this.matrikkel = null;
        this.source = null;
        this.externalId = null;
    }
}

