/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class ResidenceAddress {
    @XmlElement(name="unit-number")
    @Size(max=5)
    @Description(value="Bolignummer. Must be of format [UKHL]0000. E.g. H0304")
    private final @Size(max=5) String unitNumber;
    @XmlElement(name="house-number")
    @Size(max=5)
    @Description(value="A house number with or without a house letter. E.g. 11 or 11A")
    private final @Size(max=5) String houseNumber;
    @XmlElement(name="street-name", required=true)
    @NotNull
    @Size(max=100)
    @Description(value="The name of the street. E.g. Storgata")
    private final @NotNull @Size(max=100) String streetName;
    @XmlElement(name="postal-code", required=true)
    @NotNull
    @Size(max=10)
    private final @NotNull @Size(max=10) String postalCode;
    @XmlElement(required=true)
    @NotNull
    @Size(max=100)
    private final @NotNull @Size(max=100) String city;

    public ResidenceAddress(String houseNumber, String streetName, String postalCode, String city) {
        this(null, houseNumber, streetName, postalCode, city);
    }

    public ResidenceAddress(String unitNumber, String houseNumber, String streetName, String postalCode, String city) {
        if (!Pattern.matches("\\d{4}", postalCode)) {
            throw new IllegalArgumentException("Postal code must be 4 digits");
        }
        if (unitNumber != null && !Pattern.matches("^[KUHL]\\d{4}$", unitNumber)) {
            throw new IllegalArgumentException("Illegal unit number. Please see description for this field.");
        }
        if (houseNumber != null && !Pattern.matches("^\\d+[A-Z]*$", houseNumber)) {
            throw new IllegalArgumentException("Illegal house number. Please see description for this field.");
        }
        if (!Pattern.matches("^[a-zA-Z\u00e6\u00f8\u00e5\u00c6\u00d8\u00c5 ]+$", streetName)) {
            throw new IllegalArgumentException("Illegal Streetname. Can only contain letters and spaces");
        }
        this.unitNumber = unitNumber;
        this.houseNumber = houseNumber;
        this.streetName = streetName;
        this.postalCode = postalCode;
        this.city = city;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public String getHouseNumber() {
        return this.houseNumber;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResidenceAddress)) {
            return false;
        }
        ResidenceAddress other = (ResidenceAddress)o;
        String this$unitNumber = this.getUnitNumber();
        String other$unitNumber = other.getUnitNumber();
        if (this$unitNumber == null ? other$unitNumber != null : !this$unitNumber.equals(other$unitNumber)) {
            return false;
        }
        String this$houseNumber = this.getHouseNumber();
        String other$houseNumber = other.getHouseNumber();
        if (this$houseNumber == null ? other$houseNumber != null : !this$houseNumber.equals(other$houseNumber)) {
            return false;
        }
        String this$streetName = this.getStreetName();
        String other$streetName = other.getStreetName();
        if (this$streetName == null ? other$streetName != null : !this$streetName.equals(other$streetName)) {
            return false;
        }
        String this$postalCode = this.getPostalCode();
        String other$postalCode = other.getPostalCode();
        if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        return !(this$city == null ? other$city != null : !this$city.equals(other$city));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $unitNumber = this.getUnitNumber();
        result = result * 59 + ($unitNumber == null ? 43 : $unitNumber.hashCode());
        String $houseNumber = this.getHouseNumber();
        result = result * 59 + ($houseNumber == null ? 43 : $houseNumber.hashCode());
        String $streetName = this.getStreetName();
        result = result * 59 + ($streetName == null ? 43 : $streetName.hashCode());
        String $postalCode = this.getPostalCode();
        result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        return result;
    }

    public String toString() {
        return "ResidenceAddress(unitNumber=" + this.getUnitNumber() + ", houseNumber=" + this.getHouseNumber() + ", streetName=" + this.getStreetName() + ", postalCode=" + this.getPostalCode() + ", city=" + this.getCity() + ")";
    }

    private ResidenceAddress() {
        this.unitNumber = null;
        this.houseNumber = null;
        this.streetName = null;
        this.postalCode = null;
        this.city = null;
    }
}

