/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.validation;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import no.digipost.api.datatypes.validation.DataTypesValidationError;

public class DataTypesValidator {
    private final Validator validator;

    public DataTypesValidator(Validator validator) {
        this.validator = validator;
    }

    public DataTypesValidator() {
        this(Validation.buildDefaultValidatorFactory().getValidator());
    }

    public <T> Stream<DataTypesValidationError<T>> validate(T object) {
        return this.validator.validate(object, new Class[0]).stream().map(DataTypesValidationError::new);
    }

    public <T> Stream<DataTypesValidationError<T>> validate(Collection<T> object) {
        return object.stream().flatMap(this::validate);
    }

    public <T, U> Optional<U> validate(T object, Function<? super Set<DataTypesValidationError<T>>, U> onValidationError) {
        Set errors = this.validate(object).collect(Collectors.toSet());
        if (!errors.isEmpty()) {
            return Optional.of(onValidationError.apply(errors));
        }
        return Optional.empty();
    }

    public <T, U> Optional<U> validate(Collection<T> object, Function<? super Set<DataTypesValidationError<T>>, U> onValidationError) {
        Set errors = this.validate(object).collect(Collectors.toSet());
        if (!errors.isEmpty()) {
            return Optional.of(onValidationError.apply(errors));
        }
        return Optional.empty();
    }

    public <T, U extends Exception> void validateOrThrow(T object, Function<? super Set<DataTypesValidationError<T>>, U> onValidationError) throws U {
        Optional<U> validate = this.validate(object, onValidationError);
        if (validate.isPresent()) {
            throw (Exception)validate.get();
        }
    }

    public <T, U extends Exception> void validateOrThrow(Collection<T> object, Function<? super Set<DataTypesValidationError<T>>, U> onValidationError) throws U {
        Optional<U> validate = this.validate(object, onValidationError);
        if (validate.isPresent()) {
            throw (Exception)validate.get();
        }
    }
}

