/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.nio.AbstractNioStreamConnection;
import org.xnio.nio.ChannelClosed;
import org.xnio.nio.NioSocketConduit;
import org.xnio.nio.WorkerThread;

final class NioSocketStreamConnection
extends AbstractNioStreamConnection {
    private final ChannelClosed closedHandle;
    private final NioSocketConduit conduit;
    private static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.CLOSE_ABORT).add(Options.IP_TRAFFIC_CLASS).add(Options.KEEP_ALIVE).add(Options.READ_TIMEOUT).add(Options.RECEIVE_BUFFER).add(Options.SEND_BUFFER).add(Options.TCP_NODELAY).add(Options.TCP_OOB_INLINE).add(Options.WRITE_TIMEOUT).create();

    NioSocketStreamConnection(WorkerThread workerThread, SelectionKey key, ChannelClosed closedHandle) {
        super(workerThread);
        this.conduit = new NioSocketConduit(workerThread, key, this);
        key.attach(this.conduit);
        this.closedHandle = closedHandle;
        this.setSinkConduit(this.conduit);
        this.setSourceConduit(this.conduit);
    }

    public SocketAddress getPeerAddress() {
        Socket socket = this.conduit.getSocketChannel().socket();
        return new InetSocketAddress(socket.getInetAddress(), socket.getPort());
    }

    public SocketAddress getLocalAddress() {
        Socket socket = this.conduit.getSocketChannel().socket();
        return new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort());
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.CLOSE_ABORT) {
            return (T)option.cast((Object)(this.conduit.getSocketChannel().socket().getSoLinger() == 0 ? 1 : 0));
        }
        if (option == Options.IP_TRAFFIC_CLASS) {
            return (T)option.cast((Object)this.conduit.getSocketChannel().socket().getTrafficClass());
        }
        if (option == Options.KEEP_ALIVE) {
            return (T)option.cast((Object)this.conduit.getSocketChannel().socket().getKeepAlive());
        }
        if (option == Options.READ_TIMEOUT) {
            return (T)option.cast((Object)this.conduit.getReadTimeout());
        }
        if (option == Options.RECEIVE_BUFFER) {
            return (T)option.cast((Object)this.conduit.getSocketChannel().socket().getReceiveBufferSize());
        }
        if (option == Options.SEND_BUFFER) {
            return (T)option.cast((Object)this.conduit.getSocketChannel().socket().getSendBufferSize());
        }
        if (option == Options.TCP_NODELAY) {
            return (T)option.cast((Object)this.conduit.getSocketChannel().socket().getTcpNoDelay());
        }
        if (option == Options.TCP_OOB_INLINE) {
            return (T)option.cast((Object)this.conduit.getSocketChannel().socket().getOOBInline());
        }
        if (option == Options.WRITE_TIMEOUT) {
            return (T)option.cast((Object)this.conduit.getWriteTimeout());
        }
        return null;
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Object result;
        if (option == Options.CLOSE_ABORT) {
            result = option.cast((Object)(this.conduit.getSocketChannel().socket().getSoLinger() == 0 ? 1 : 0));
            this.conduit.getSocketChannel().socket().setSoLinger((Boolean)Options.CLOSE_ABORT.cast(value, (Object)Boolean.FALSE), 0);
        } else if (option == Options.IP_TRAFFIC_CLASS) {
            result = option.cast((Object)this.conduit.getSocketChannel().socket().getTrafficClass());
            this.conduit.getSocketChannel().socket().setTrafficClass((Integer)Options.IP_TRAFFIC_CLASS.cast(value));
        } else if (option == Options.KEEP_ALIVE) {
            result = option.cast((Object)this.conduit.getSocketChannel().socket().getKeepAlive());
            this.conduit.getSocketChannel().socket().setKeepAlive((Boolean)Options.KEEP_ALIVE.cast(value, (Object)Boolean.FALSE));
        } else if (option == Options.READ_TIMEOUT) {
            result = option.cast((Object)this.conduit.getAndSetReadTimeout(value == null ? 0 : (Integer)Options.READ_TIMEOUT.cast(value)));
        } else if (option == Options.RECEIVE_BUFFER) {
            result = option.cast((Object)this.conduit.getSocketChannel().socket().getReceiveBufferSize());
            this.conduit.getSocketChannel().socket().setReceiveBufferSize((Integer)Options.RECEIVE_BUFFER.cast(value));
        } else if (option == Options.SEND_BUFFER) {
            result = option.cast((Object)this.conduit.getSocketChannel().socket().getSendBufferSize());
            this.conduit.getSocketChannel().socket().setSendBufferSize((Integer)Options.SEND_BUFFER.cast(value));
        } else if (option == Options.TCP_NODELAY) {
            result = option.cast((Object)this.conduit.getSocketChannel().socket().getTcpNoDelay());
            this.conduit.getSocketChannel().socket().setTcpNoDelay((Boolean)Options.TCP_NODELAY.cast(value, (Object)Boolean.FALSE));
        } else if (option == Options.TCP_OOB_INLINE) {
            result = option.cast((Object)this.conduit.getSocketChannel().socket().getOOBInline());
            this.conduit.getSocketChannel().socket().setOOBInline((Boolean)Options.TCP_OOB_INLINE.cast(value, (Object)Boolean.FALSE));
        } else if (option == Options.WRITE_TIMEOUT) {
            result = option.cast((Object)this.conduit.getAndSetWriteTimeout(value == null ? 0 : (Integer)Options.WRITE_TIMEOUT.cast(value)));
        } else {
            return null;
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAction() throws IOException {
        try {
            this.conduit.getWorkerThread().cancelKey(this.conduit.getSelectionKey());
            this.conduit.getSocketChannel().close();
        }
        catch (ClosedChannelException ignored) {
        }
        finally {
            ChannelClosed closedHandle = this.closedHandle;
            if (closedHandle != null) {
                closedHandle.channelClosed();
            }
        }
    }

    protected void notifyWriteClosed() {
        this.conduit.writeTerminated();
    }

    protected void notifyReadClosed() {
        this.conduit.readTerminated();
    }

    SocketChannel getChannel() {
        return this.conduit.getSocketChannel();
    }

    NioSocketConduit getConduit() {
        return this.conduit;
    }
}

