/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.filters.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import no.digipost.api.client.ApiService;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.security.ClientResponseToVerify;
import no.digipost.api.client.security.ResponseMessageSignatureUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;
import org.bouncycastle.util.encoders.Base64;

public class ResponseSignatureInterceptor
implements HttpResponseInterceptor {
    public static final String NOT_SIGNED_RESPONSE = "NOT_SIGNED_RESPONSE";
    private final ApiService apiService;

    public ResponseSignatureInterceptor(ApiService apiService) {
        this.apiService = apiService;
    }

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Boolean notSignedResponse = (Boolean)context.getAttribute(NOT_SIGNED_RESPONSE);
        if (notSignedResponse != null && notSignedResponse.booleanValue()) {
            return;
        }
        try {
            String serverSignaturBase64 = this.getServerSignaturFromResponse(response);
            byte[] serverSignaturBytes = Base64.decode((byte[])serverSignaturBase64.getBytes());
            String signatureString = ResponseMessageSignatureUtil.getCanonicalResponseRepresentation(new ClientResponseToVerify(context, response));
            Signature instance = Signature.getInstance("SHA256WithRSAEncryption");
            instance.initVerify(this.lastSertifikat());
            instance.update(signatureString.getBytes());
            boolean verified = instance.verify(serverSignaturBytes);
            if (!verified) {
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Response from server did not match signature.");
            }
        }
        catch (Exception e) {
            if (e instanceof DigipostClientException) {
                throw (DigipostClientException)e;
            }
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "An exception occured during server response signature verification. " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    private String getServerSignaturFromResponse(HttpResponse response) {
        String serverSignaturString = null;
        Header firstHeader = response.getFirstHeader("X-Digipost-Signature");
        if (firstHeader != null) {
            serverSignaturString = firstHeader.getValue();
        }
        if (StringUtils.isBlank(serverSignaturString)) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Missing X-Digipost-Signature header. Signature from server could not be validated");
        }
        return serverSignaturString;
    }

    public X509Certificate lastSertifikat() {
        try {
            ByteArrayInputStream certStream = new ByteArrayInputStream(this.apiService.getEntryPoint().getCertificate().getBytes());
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate sertifikat = (X509Certificate)cf.generateCertificate(certStream);
            if (sertifikat == null) {
                throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Unable to load Digipost's public key. Signature from server could not be validated");
            }
            return sertifikat;
        }
        catch (GeneralSecurityException e) {
            throw new DigipostClientException(ErrorCode.SERVER_SIGNATURE_ERROR, "Unable to load Digipost's public key. Signature from server could not be validated");
        }
    }
}

