/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class FileType {
    private static final Pattern ALLOWED_CHARACTERS = Pattern.compile("^[a-z0-9\\-_]+$");
    public static final FileType PDF = new FileType("pdf");
    public static final FileType HTM = new FileType("htm");
    public static final FileType HTML = new FileType("html");
    public static final FileType XHTML = new FileType("xhtml");
    public static final FileType XHT = new FileType("xht");
    public static final FileType PNG = new FileType("png");
    public static final FileType JPG = new FileType("jpg");
    public static final FileType JPEG = new FileType("jpeg");
    public static final FileType GIF = new FileType("gif");
    public static final FileType ZIP = new FileType("zip");
    public static final FileType EHF = new FileType("ehf");
    private final String fileType;

    public FileType(String fileType) {
        String normalized = StringUtils.trimToEmpty((String)fileType).toLowerCase();
        this.fileType = normalized.length() >= 30 || !ALLOWED_CHARACTERS.matcher(normalized).matches() ? "" : normalized;
    }

    public String toString() {
        return this.fileType;
    }

    public int hashCode() {
        return Objects.hashCode(this.fileType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FileType)) {
            return false;
        }
        FileType other = (FileType)obj;
        return Objects.equals(other.fileType, this.fileType);
    }

    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.fileType);
    }

    public static FileType fromFilename(String filename) {
        return new FileType(FilenameUtils.getExtension((String)filename));
    }
}

