/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.client.representations.DigipostUri;
import no.digipost.api.client.representations.Relation;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="link", propOrder={"rel", "uri", "mediaType"})
public class Link {
    private static final String RELATIONS_BASE_PATH = "/relations";
    @XmlTransient
    private Relation rel;
    @XmlTransient
    private String relationBaseUri;
    @XmlAttribute(required=true)
    private String uri;
    @XmlAttribute(name="media-type")
    private String mediaType;

    public Link(Relation relation, DigipostUri uri, String mediaType) {
        this.rel = relation;
        this.relationBaseUri = uri.getBaseUri() + RELATIONS_BASE_PATH;
        this.uri = uri.getUri().toString();
        this.mediaType = mediaType;
    }

    public Link(Relation relation, DigipostUri uri) {
        this(relation, uri, "application/vnd.digipost-v7+xml");
    }

    Link() {
    }

    private String parseRelationsBaseUri(String rel) {
        return rel.substring(0, rel.lastIndexOf("/"));
    }

    private Relation parseRel(String rel) {
        if (rel == null || rel.isEmpty()) {
            return Relation.UNSUPPORTED;
        }
        try {
            return Relation.valueOf(rel.substring(rel.lastIndexOf("/") + 1).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return Relation.UNSUPPORTED;
        }
    }

    public String getRelationUri() {
        return this.relationBaseUri + "/" + this.rel.name().toLowerCase();
    }

    @XmlAttribute
    public String getRel() {
        return this.getRelationUri();
    }

    public void setRel(String rel) {
        this.rel = this.parseRel(rel);
        this.relationBaseUri = this.parseRelationsBaseUri(rel);
    }

    public Relation getRelationName() {
        return this.rel;
    }

    public URI getUri() {
        try {
            return new URI(this.uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equalsRelation(Relation relation) {
        return this.rel.equals((Object)relation);
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 1).append((Object)this.mediaType).append((Object)this.rel).append((Object)this.relationBaseUri).append((Object)this.uri).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        return new EqualsBuilder().append((Object)this.mediaType, (Object)other.mediaType).append((Object)this.rel, (Object)other.rel).append((Object)this.relationBaseUri, (Object)other.relationBaseUri).append((Object)this.uri, (Object)other.uri).isEquals();
    }
}

