/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="norwegian-address", propOrder={"addressline1", "addressline2", "addressline3", "zipCode", "city"})
public class NorwegianAddress {
    protected String addressline1;
    protected String addressline2;
    protected String addressline3;
    @XmlElement(name="zip-code", required=true)
    protected String zipCode;
    @XmlElement(required=true)
    protected String city;

    public NorwegianAddress() {
        this(null, null, null);
    }

    public NorwegianAddress(String zipCode, String city) {
        this(null, zipCode, city);
    }

    public NorwegianAddress(String addressline1, String zipCode, String city) {
        this(addressline1, null, zipCode, city);
    }

    public NorwegianAddress(String addressline1, String addressline2, String zipCode, String city) {
        this(addressline1, addressline2, null, zipCode, city);
    }

    public NorwegianAddress(String addressline1, String addressline2, String addressline3, String zipCode, String city) {
        this.addressline1 = addressline1;
        this.addressline2 = addressline2;
        this.addressline3 = addressline3;
        this.zipCode = zipCode;
        this.city = city;
    }

    public String getAddressline1() {
        return this.addressline1;
    }

    public void setAddressline1(String value) {
        this.addressline1 = value;
    }

    public String getAddressline2() {
        return this.addressline2;
    }

    public void setAddressline2(String value) {
        this.addressline2 = value;
    }

    public String getAddressline3() {
        return this.addressline3;
    }

    public void setAddressline3(String value) {
        this.addressline3 = value;
    }

    public List<String> getAddresslines() {
        ArrayList<String> lines = new ArrayList<String>(3);
        if (this.addressline1 != null) {
            lines.add(this.addressline1);
        }
        if (this.addressline2 != null) {
            lines.add(this.addressline2);
        }
        if (this.addressline3 != null) {
            lines.add(this.addressline3);
        }
        return lines;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String value) {
        this.zipCode = value;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String value) {
        this.city = value;
    }

    public boolean isSameAddressAs(NorwegianAddress other) {
        return other != null && this.trimEquals(this.city, other.city) && this.trimEquals(this.zipCode, other.zipCode);
    }

    private boolean trimEquals(String first, String second) {
        return StringUtils.trimToEmpty((String)first).equals(StringUtils.trimToEmpty((String)second));
    }
}

