/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.representations.sender;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.digipost.api.client.representations.sender.SenderFeature;

public final class SenderFeatureName {
    public static final SenderFeatureName DIGIPOST_DELIVERY = new SenderFeatureName("no.digipost.feature.delivery.digipost", false);
    public static final SenderFeatureName DIGIPOST_DELIVERY_WITH_PRINT_FALLBACK = new SenderFeatureName("no.digipost.feature.delivery.digipost-with-print-fallback", false);
    public static final SenderFeatureName DELIVERY_DIRECT_TO_PRINT = new SenderFeatureName("no.digipost.feature.delivery.direct-to-print", false);
    public static final SenderFeatureName PRINTVALIDATION_PDFVERSION = new SenderFeatureName("no.digipost.feature.validation.print.pdf.version", false);
    public static final SenderFeatureName PRINTVALIDATION_FONTS = new SenderFeatureName("no.digipost.feature.validation.print.fonts", false);
    public static final SenderFeatureName PRINTVALIDATION_PAGEAMOUNT = new SenderFeatureName("no.digipost.feature.validation.print.pageamount", false);
    public static final SenderFeatureName PRINTVALIDATION_MARGINS_LEFT = new SenderFeatureName("no.digipost.feature.validation.print.margins.left", false);
    public static final SenderFeatureName PRINTVALIDATION_POSITIVE_BLEED = new SenderFeatureName("no.digipost.feature.validation.print.bleed", false);
    public static final SenderFeatureName PRINTVALIDATION_NEGATIVE_BLEED = new SenderFeatureName("no.digipost.feature.validation.print.negativebleed", false);
    private static final Map<String, SenderFeatureName> KNOWN_FEATURES = Stream.of(DIGIPOST_DELIVERY, DIGIPOST_DELIVERY_WITH_PRINT_FALLBACK, DELIVERY_DIRECT_TO_PRINT, PRINTVALIDATION_FONTS, PRINTVALIDATION_MARGINS_LEFT, PRINTVALIDATION_PAGEAMOUNT, PRINTVALIDATION_PDFVERSION, PRINTVALIDATION_POSITIVE_BLEED, PRINTVALIDATION_NEGATIVE_BLEED).collect(Collectors.collectingAndThen(Collectors.toMap(name -> name.identificator, Function.identity()), Collections::unmodifiableMap));
    public final String identificator;
    private final boolean custom;

    private SenderFeatureName(String identificator, boolean custom) {
        this.identificator = identificator;
        this.custom = custom;
    }

    public static SenderFeatureName from(String identificator) {
        SenderFeatureName known = KNOWN_FEATURES.get(identificator);
        return known != null ? known : new SenderFeatureName(identificator, true);
    }

    public SenderFeature withParam(String param) {
        return new SenderFeature(this, param);
    }

    public SenderFeature withNoParam() {
        return this.withParam(null);
    }

    public String toString() {
        return this.identificator + (this.custom ? " (custom)" : "");
    }

    public boolean equals(Object o) {
        return o instanceof SenderFeatureName && Objects.equals(((SenderFeatureName)o).identificator, this.identificator) && ((SenderFeatureName)o).custom == this.custom;
    }

    public int hashCode() {
        return Objects.hash(this.identificator, this.custom);
    }
}

