/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import no.digipost.api.client.errorhandling.DigipostClientException;
import no.digipost.api.client.errorhandling.ErrorCode;
import no.digipost.api.client.representations.EncryptionKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMParser;

public class DigipostPublicKey {
    public final PublicKey publicKey;
    public final String publicKeyHash;

    public DigipostPublicKey(EncryptionKey encryptionKey) {
        try (StringReader sourceReader = new StringReader(encryptionKey.getValue());
             PEMParser pemParser = new PEMParser((Reader)sourceReader);){
            PublicKey publicKey;
            SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)pemParser.readObject();
            X509EncodedKeySpec spec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            this.publicKey = publicKey = KeyFactory.getInstance("RSA").generatePublic(spec);
            this.publicKeyHash = encryptionKey.getKeyId();
        }
        catch (Exception e) {
            throw new DigipostClientException(ErrorCode.FAILED_TO_PARSE_ENCRYPTION_KEY, "Feil ved parsing av krypteringsn\u00f8kkel fra Digipost.", e);
        }
    }
}

