/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import no.digipost.api.client.representations.EncryptionKey;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class FakeEncryptionKey {
    public static EncryptionKey createFakeEncryptionKey() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osWriter = new OutputStreamWriter(baos);
             JcaPEMWriter writer = new JcaPEMWriter((Writer)osWriter);){
            KeyPairGenerator factory = KeyPairGenerator.getInstance("RSA");
            factory.initialize(2048);
            KeyPair keyPair = factory.generateKeyPair();
            writer.writeObject((Object)keyPair.getPublic());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed creation of fake encryption key.", e);
        }
        EncryptionKey fakeKey = new EncryptionKey();
        fakeKey.setKeyId("fake-hash");
        fakeKey.setValue(new String(baos.toByteArray()));
        return fakeKey;
    }
}

