/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.client.util;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingUtil.class);

    public static void logResponse(HttpResponse response) {
        LOG.info("HTTP response status code: {}", (Object)response.getStatusLine().getStatusCode());
        LOG.info("HTTP response headers: {}", (Object)LoggingUtil.headersAsString(response.getAllHeaders()));
    }

    public static String headersAsString(Header[] httpHeaders) {
        StringBuilder result = new StringBuilder();
        for (Header header : httpHeaders) {
            result.append(header.getName()).append(" :");
            for (HeaderElement element : header.getElements()) {
                result.append(" ").append(element.getValue());
            }
            result.append("; ");
        }
        return result.toString();
    }
}

