/*
 * Decompiled with CFR 0.152.
 */
package no.motif;

import java.util.Collection;
import java.util.Objects;
import no.motif.Iterate;
import no.motif.NOP;
import no.motif.f.Do;
import no.motif.f.Fn;
import no.motif.f.Fn0;
import no.motif.f.Fn2;
import no.motif.f.Predicate;
import no.motif.f.combine.Conjunction;
import no.motif.f.combine.ConjunctionPremise;
import no.motif.f.combine.Disjunction;
import no.motif.f.combine.DisjunctionPremise;
import no.motif.f.combine.DoChain;
import no.motif.f.combine.Fn2Chain;
import no.motif.f.combine.FnChain;
import no.motif.f.combine.RunnableChain;
import no.motif.f.combine.When;
import no.motif.f.combine.Where;
import no.motif.f.impl.Constant;
import no.motif.f.impl.Throw;
import no.motif.iter.ExtractingIterable;
import no.motif.types.Elements;

public final class Base {
    public static final Predicate<Object> isNull = new Predicate<Object>(){

        @Override
        public boolean $(Object value) {
            return value == null;
        }
    };
    public static final Predicate<Object> notNull = Base.not(isNull);
    public static final Fn<Object, String> toString = new Fn<Object, String>(){

        @Override
        public String $(Object value) {
            return String.valueOf(value);
        }
    };
    public static final Fn<Object, Integer> hashCode = new Fn<Object, Integer>(){

        @Override
        public Integer $(Object o) {
            return o != null ? o.hashCode() : 0;
        }
    };

    public static <T> Predicate<T> not(T o) {
        return Base.not(Base.equalTo(o));
    }

    public static <T> Predicate<T> not(final Predicate<T> p) {
        return new Predicate<T>(){

            @Override
            public boolean $(T value) {
                return !p.$(value);
            }
        };
    }

    public static <T, P> Predicate<T> where(Fn<T, P> fn, Predicate<? super P> predicate) {
        return new Where<T, P>(fn, predicate);
    }

    public static <T> Conjunction<T> both(Predicate<T> predicate) {
        return new Conjunction(predicate);
    }

    public static ConjunctionPremise both(Fn0<Boolean> premise) {
        return new ConjunctionPremise(premise);
    }

    @SafeVarargs
    public static <T> Conjunction<T> allOf(Predicate<? super T> ... predicates) {
        return new Conjunction<T>(predicates);
    }

    @SafeVarargs
    public static ConjunctionPremise allOf(Fn0<Boolean> ... premises) {
        return new ConjunctionPremise(premises);
    }

    public static <T> Disjunction<T> either(T o) {
        return Base.either(Base.equalTo(o));
    }

    public static <T> Disjunction<T> either(Predicate<T> predicate) {
        return new Disjunction(predicate);
    }

    public static DisjunctionPremise either(Fn0<Boolean> premise) {
        return new DisjunctionPremise(premise);
    }

    @SafeVarargs
    public static <T> Disjunction<T> anyOf(T ... objects) {
        Predicate[] equalToPredicates = Iterate.on(objects).map(new Fn<T, Predicate<T>>(){

            @Override
            public Predicate<T> $(T o) {
                return Base.equalTo(o);
            }
        }).collect().toArray(new Predicate[objects.length]);
        return Base.anyOf(equalToPredicates);
    }

    @SafeVarargs
    public static <T> Disjunction<T> anyOf(Predicate<? super T> ... predicates) {
        return new Disjunction<T>(predicates);
    }

    @SafeVarargs
    public static DisjunctionPremise anyOf(Fn0<Boolean> ... premises) {
        return new DisjunctionPremise(premises);
    }

    public static <E, I extends Iterable<E>> Predicate<I> all(final Predicate<? super E> predicate) {
        return new Predicate<I>(){

            @Override
            public boolean $(I iterable) {
                return Iterate.on(iterable).filter(Base.not(predicate)).isEmpty();
            }
        };
    }

    public static <E, I extends Iterable<E>> Predicate<I> exists(E element) {
        return Base.exists(Base.equalTo(element));
    }

    public static <E, I extends Iterable<E>> Predicate<I> exists(final Predicate<? super E> element) {
        return new Predicate<I>(){

            @Override
            public boolean $(I iterable) {
                return Iterate.on(iterable).exists(element);
            }
        };
    }

    public static <T> Predicate<T> is(T value) {
        return Base.equalTo(value);
    }

    public static <T> Predicate<T> equalTo(T value) {
        return Base.equalTo(Base.always(value));
    }

    public static <T> Predicate<T> equalTo(final Fn0<? super T> value) {
        return new Predicate<T>(){

            @Override
            public boolean $(T input) {
                return Objects.equals(input, value.$());
            }
        };
    }

    public static <T extends Comparable<? super T>> Predicate<T> lessThan(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean $(T candidate) {
                return candidate.compareTo((Comparable)value) < 0;
            }
        };
    }

    public static <T extends Comparable<? super T>> Predicate<T> equalOrLessThan(T value) {
        return Base.either(Base.equalTo(value)).or(Base.lessThan(value));
    }

    public static <T extends Comparable<? super T>> Predicate<T> greaterThan(final T value) {
        return new Predicate<T>(){

            @Override
            public boolean $(T candidate) {
                return candidate.compareTo((Comparable)value) > 0;
            }
        };
    }

    public static <T extends Comparable<? super T>> Predicate<T> equalOrGreaterThan(T value) {
        return Base.either(Base.equalTo(value)).or(Base.greaterThan(value));
    }

    @SafeVarargs
    public static <T, E> Fn<T, Elements<E>> extract(final Fn<? super T, ? extends E> ... extractors) {
        return new Fn<T, Elements<E>>(){

            @Override
            public Elements<E> $(T value) {
                return Iterate.on(new ExtractingIterable(value, Iterate.on(extractors)));
            }
        };
    }

    public static <I, O> When<I, O> when(Predicate<? super I> condition, Fn<? super I, ? extends O> fn) {
        return new When<I, O>(condition, fn);
    }

    public static final <I, O> FnChain<I, O> first(Fn<I, O> fn) {
        return FnChain.chain(fn);
    }

    public static final <I1, I2, O> Fn2Chain<I1, I2, O, O> first(Fn2<I1, I2, O> fn2) {
        return new Fn2Chain(fn2, NOP.fn());
    }

    public static final RunnableChain first(Runnable runnable) {
        return new RunnableChain(runnable, NOP.runnable);
    }

    public static <V> DoChain<V> first(Do<V> action) {
        return new DoChain<Object>(action, NOP.doNothing);
    }

    public static <I1, I2, V> Constant<I1, I2, V> always(V value) {
        return new Constant(value);
    }

    public static <T> Predicate<T> always(boolean bool) {
        return bool ? Predicate.Always.yes() : Predicate.Always.no();
    }

    public static <I1, I2, O> Throw<I1, I2, O> alwaysThrow(Exception ex) {
        return new Throw(ex);
    }

    public static <T> Predicate<T> containedIn(final Collection<? extends T> collection) {
        return collection == null || collection.isEmpty() ? Predicate.Always.no() : new Predicate<T>(){

            @Override
            public boolean $(T value) {
                return collection.contains(value);
            }
        };
    }

    private Base() {
    }
}

