/*
 * Decompiled with CFR 0.152.
 */
package no.motif;

import no.motif.Base;
import no.motif.Longs;
import no.motif.f.Apply;
import no.motif.f.Fn;
import no.motif.f.Fn2;
import no.motif.f.Predicate;
import no.motif.f.base.FalseIfNull;

public final class Ints {
    public static final Predicate<Integer> even = new FalseIfNull<Integer>(){

        @Override
        public boolean orElse(Integer i) {
            return i % 2 == 0;
        }
    };
    public static final Predicate<Integer> odd = Base.not(even);
    public static final Fn<Number, Integer> intValue = Base.when(Base.notNull, new Fn<Number, Integer>(){

        @Override
        public Integer $(Number value) {
            return value.intValue();
        }
    });
    public static final Fn2<Number, Number, Integer> sum = Base.first(Longs.sum).then(intValue);
    public static final Fn2<Number, Number, Integer> multiply = Base.first(Longs.multiply).then(intValue);
    public static final Fn2<Number, Number, Integer> divide = Base.first(Longs.divide).then(intValue);
    public static final Fn<Number, Integer> doubled = Base.first(Longs.doubled).then(intValue);
    public static final Fn<Number, Integer> rounded = Base.first(Longs.rounded).then(intValue);
    public static final Fn<Number, Integer> increment = Base.first(Longs.increment).then(intValue);

    public static final Fn<Number, Integer> add(int value) {
        return Base.when(Base.notNull, Apply.partially(sum).of(value));
    }

    public static final Fn<Number, Integer> subtract(int value) {
        return Ints.add(value * -1);
    }

    public static final Fn<Number, Integer> multipliedBy(int value) {
        return Base.when(Base.notNull, Apply.partially(multiply).of(value));
    }

    public static final Fn<Number, Integer> dividedBy(int value) {
        return Base.when(Base.notNull, Apply.partially(Apply.argsReversed(divide)).of(value));
    }

    private Ints() {
    }
}

