/*
 * Decompiled with CFR 0.152.
 */
package no.motif;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import no.motif.Base;
import no.motif.NOP;
import no.motif.Singular;
import no.motif.f.Fn;
import no.motif.f.Predicate;
import no.motif.iter.CharsInStringIterator;
import no.motif.iter.PreparedIterable;
import no.motif.iter.boxing.BytesIterable;
import no.motif.iter.ordering.ByPropertyComparator;
import no.motif.iter.ordering.EnhancedComparator;
import no.motif.iter.ordering.EnhancedComparatorImpl;
import no.motif.single.Optional;
import no.motif.types.Elements;

public final class Iterate {
    private static final Elements<?> NONE = new PreparedIterable(Collections.emptyList());
    public static final Predicate<Iterable<?>> empty = new Predicate<Iterable<?>>(){

        @Override
        public boolean $(Iterable<?> iterable) {
            return Iterate.on(iterable).isEmpty();
        }
    };
    public static final Predicate<Iterator<?>> hasNext = new Predicate<Iterator<?>>(){

        @Override
        public boolean $(Iterator<?> iterator) {
            return iterator.hasNext();
        }
    };
    public static final Fn<Collection<?>, Integer> size = Base.when(Base.notNull, new Fn<Collection<?>, Integer>(){

        @Override
        public Integer $(Collection<?> collection) {
            return collection.size();
        }
    }).orElse(0);

    public static <T> Elements<T> none() {
        return NONE;
    }

    public static Elements<Character> on(final CharSequence string) {
        if (string == null) {
            return Iterate.none();
        }
        return Iterate.newInstance(new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return new CharsInStringIterator(string);
            }
        });
    }

    @SafeVarargs
    public static <T> Elements<T> on(T ... elements) {
        return Iterate.newInstance(elements != null ? Arrays.asList(elements) : null);
    }

    public static Elements<Byte> on(byte[] bytes) {
        return Iterate.newInstance(bytes != null ? new BytesIterable(bytes) : null);
    }

    public static <K, V> Elements<Map.Entry<K, V>> on(Map<K, V> map) {
        return Iterate.on(map != null ? map.entrySet() : null);
    }

    public static <T> Elements<T> on(Iterable<T> elements) {
        return elements instanceof Elements ? (Elements<T>)elements : Iterate.newInstance(elements);
    }

    private static <T> Elements<T> newInstance(Iterable<T> elements) {
        if (elements == null || elements instanceof Collection && ((Collection)elements).isEmpty()) {
            return Iterate.none();
        }
        return new PreparedIterable<T>(elements);
    }

    public static <T, P extends Comparable<P>> EnhancedComparator<T> by(Fn<T, P> property) {
        return new EnhancedComparatorImpl(new ByPropertyComparator<T, P>(property));
    }

    public static <T extends Comparable<T>> EnhancedComparator<T> byOrderingOf(Class<T> comparableType) {
        return Iterate.by(NOP.fn());
    }

    public static final <T> Fn<Iterator<T>, T> next() {
        return new Fn<Iterator<T>, T>(){

            @Override
            public T $(Iterator<T> iterator) {
                return iterator.next();
            }
        };
    }

    public static <T> Fn<T, T> last(final Fn<? super T, ? extends T> next) {
        return new Fn<T, T>(){

            @Override
            public T $(T value) {
                return ((Optional)Singular.optional(next.$(value)).map((Fn)this)).orElse(value);
            }
        };
    }

    public static <I, O> Fn<I, Iterable<O>> toIterable(final Fn<I, O[]> yieldsArray) {
        return new Fn<I, Iterable<O>>(){

            @Override
            public Iterable<O> $(I value) {
                return Iterate.on((Object[])yieldsArray.$(value));
            }
        };
    }

    private Iterate() {
    }
}

