/*
 * Decompiled with CFR 0.152.
 */
package no.motif;

import no.motif.Base;
import no.motif.f.Apply;
import no.motif.f.Fn;
import no.motif.f.Fn2;
import no.motif.f.Predicate;
import no.motif.f.base.FalseIfNull;
import no.motif.f.base.NullIfEitherArgIsNull;

public final class Longs {
    public static final Predicate<Long> even = new FalseIfNull<Long>(){

        @Override
        public boolean orElse(Long i) {
            return i % 2L == 0L;
        }
    };
    public static final Predicate<Long> odd = Base.not(even);
    public static final Fn<Number, Long> longValue = Base.when(Base.notNull, new Fn<Number, Long>(){

        @Override
        public Long $(Number value) {
            return value.longValue();
        }
    });
    public static final Fn2<Number, Number, Long> sum = new NullIfEitherArgIsNull<Number, Number, Long>(){

        @Override
        public Long orElse(Number first, Number second) {
            return first.longValue() + second.longValue();
        }
    };
    public static final Fn2<Number, Number, Long> multiply = new NullIfEitherArgIsNull<Number, Number, Long>(){

        @Override
        public Long orElse(Number factor1, Number factor2) {
            return factor1.longValue() * factor2.longValue();
        }
    };
    public static final Fn2<Number, Number, Long> divide = new Fn2<Number, Number, Long>(){

        @Override
        public Long $(Number factor1, Number factor2) {
            return factor1.longValue() / factor2.longValue();
        }
    };
    public static final Fn<Number, Long> doubled = Longs.multipliedBy(2L);
    public static final Fn<Number, Long> rounded = Base.when(Base.notNull, new Fn<Number, Long>(){

        @Override
        public Long $(Number decimal) {
            return Math.round(decimal.doubleValue());
        }
    });
    public static final Fn<Number, Long> increment = Base.when(Base.notNull, new Fn<Number, Long>(){

        @Override
        public Long $(Number n) {
            return n.longValue() + 1L;
        }
    });

    public static final Fn<Number, Long> add(long value) {
        return Base.when(Base.notNull, Apply.partially(sum).of(value));
    }

    public static final Fn<Number, Long> subtract(long value) {
        return Longs.add(value * -1L);
    }

    public static final Fn<Number, Long> multipliedBy(long value) {
        return Base.when(Base.notNull, Apply.partially(multiply).of(value));
    }

    public static final Fn<Number, Long> dividedBy(long value) {
        return Base.when(Base.notNull, Apply.partially(Apply.argsReversed(divide)).of(value));
    }

    private Longs() {
    }
}

