/*
 * Decompiled with CFR 0.152.
 */
package no.motif;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import no.motif.Base;
import no.motif.Chars;
import no.motif.Exceptions;
import no.motif.Implicits;
import no.motif.Ints;
import no.motif.Iterate;
import no.motif.NOP;
import no.motif.Singular;
import no.motif.f.Apply;
import no.motif.f.Fn;
import no.motif.f.Fn2;
import no.motif.f.Predicate;
import no.motif.f.base.FalseIfNull;
import no.motif.iter.SplitOnCharacter;
import no.motif.iter.SplitOnSubstring;
import no.motif.single.Optional;
import no.motif.types.Mappable;

public final class Strings {
    public static final Fn<String, Integer> toInt = new Fn<String, Integer>(){

        @Override
        public Integer $(String numeric) {
            return numeric != null ? Integer.valueOf(numeric) : 0;
        }
    };
    public static final Fn<String, Long> toLong = new Fn<String, Long>(){

        @Override
        public Long $(String numeric) {
            return numeric != null ? Long.valueOf(numeric) : 0L;
        }
    };
    public static final Fn<String, Double> toDouble = new Fn<String, Double>(){

        @Override
        public Double $(String decimalValue) {
            return decimalValue != null ? Double.valueOf(decimalValue) : 0.0;
        }
    };
    public static final Fn<String, Iterable<Character>> toChars = new Fn<String, Iterable<Character>>(){

        @Override
        public Iterable<Character> $(String value) {
            return Iterate.on(value);
        }
    };
    public static final Fn<String, Iterable<Byte>> bytes = Base.when(Base.notNull, new Fn<String, Iterable<Byte>>(){

        @Override
        public Iterable<Byte> $(String s) {
            try {
                return Iterate.on(s.getBytes(Implicits.getEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                throw Exceptions.asRuntimeException(e);
            }
        }
    }).orElse(Iterate.none());
    public static final Predicate<String> blank = Base.where(toChars, Base.all(Chars.whitespace));
    public static final Predicate<String> nonblank = Base.where(toChars, Base.exists(Base.not(Chars.whitespace)));
    public static final Predicate<String> numeric = Strings.nonblankAllChars(Chars.digit);
    public static final Predicate<String> alphanumeric = Strings.nonblankAllChars(Chars.letterOrDigit);
    public static final Predicate<String> alphabetic = Strings.nonblankAllChars(Chars.letter);
    public static final Fn<String, String> trimmed = Base.when(Base.notNull, new Fn<String, String>(){

        @Override
        public String $(String s) {
            return s.trim();
        }
    });
    public static final Fn<String, String> lowerCased = Base.when(Base.notNull, new Fn<String, String>(){

        @Override
        public String $(String s) {
            return s.toLowerCase(Implicits.getLocale());
        }
    });
    public static final Fn<String, String> upperCased = Base.when(Base.notNull, new Fn<String, String>(){

        @Override
        public String $(String s) {
            return s.toUpperCase(Implicits.getLocale());
        }
    });
    public static final Fn<String, Integer> length = Base.when(Base.notNull, new Fn<String, Integer>(){

        @Override
        public Integer $(String s) {
            return s.length();
        }
    }).orElse(0);
    public static final Fn2<Object, Object, String> concat = new Fn2<Object, Object, String>(){

        String emptyIfNull(Object o) {
            return o != null ? String.valueOf(o) : "";
        }

        @Override
        public String $(Object acc, Object c) {
            return this.emptyIfNull(acc) + this.emptyIfNull(c);
        }
    };
    public static final Fn<String, String> reversed = Base.when(Base.notNull, new Fn<String, String>(){

        @Override
        public String $(String s) {
            return new StringBuilder(s).reverse().toString();
        }
    });

    public static final Predicate<String> allChars(Predicate<Character> valid) {
        return Base.where(toChars, Base.all(valid));
    }

    public static final Predicate<String> nonblankAllChars(Predicate<Character> valid) {
        return Base.both(nonblank).and(Strings.allChars(valid));
    }

    public static final Predicate<String> hasLength(int exactLength) {
        return Strings.hasLength(Base.equalTo(exactLength));
    }

    public static final Predicate<String> hasLength(Predicate<? super Integer> accepted) {
        return Base.where(length, accepted);
    }

    public static Predicate<String> contains(final CharSequence charSequence) {
        return charSequence == null ? Predicate.Always.no() : new FalseIfNull<String>(){

            @Override
            protected boolean orElse(String string) {
                return string.contains(charSequence);
            }
        };
    }

    public static Predicate<String> startsWith(final String prefix) {
        return prefix == null ? Predicate.Always.no() : new FalseIfNull<String>(){

            @Override
            protected boolean orElse(String string) {
                return string.startsWith(prefix);
            }
        };
    }

    public static Predicate<String> endsWith(final String suffix) {
        return suffix == null ? Predicate.Always.no() : new FalseIfNull<String>(){

            @Override
            protected boolean orElse(String string) {
                return string.endsWith(suffix);
            }
        };
    }

    public static Predicate<String> matches(final String regex) {
        return regex == null ? Predicate.Always.no() : new FalseIfNull<String>(){

            @Override
            protected boolean orElse(String string) {
                return string.matches(regex);
            }
        };
    }

    public static Fn<Object, String> prepend(String prefix) {
        return Apply.partially(concat).of(prefix);
    }

    public static Fn<Object, String> append(String suffix) {
        return Apply.partially(Apply.argsReversed(concat)).of(suffix);
    }

    public static Fn<String, String> substring(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex < 0) {
            return Base.alwaysThrow(new StringIndexOutOfBoundsException("Cannot extract substring using negative index. beginIndex: " + beginIndex + ", endIndex: " + endIndex));
        }
        return Strings.substring(Base.always(beginIndex), Base.always(endIndex));
    }

    public static Fn<String, String> substring(final Fn<? super String, Integer> beginIndex, final Fn<? super String, Integer> endIndex) {
        return Base.when(Base.notNull, new Fn<String, String>(){

            @Override
            public String $(String s) {
                return (String)((Optional)((Optional)Singular.optional(s).map(Strings.before(endIndex))).map(Strings.from(beginIndex))).orNull();
            }
        });
    }

    public static Fn<String, String> first(final int charAmount) {
        return Base.when(Base.notNull, new Fn<String, String>(){

            @Override
            public String $(String s) {
                return charAmount > s.length() ? s : s.substring(0, charAmount);
            }
        }).orElse("");
    }

    public static Fn<String, String> last(final int charAmount) {
        return Base.when(Base.notNull, new Fn<String, String>(){

            @Override
            public String $(String s) {
                return charAmount > s.length() ? s : s.substring(s.length() - charAmount, s.length());
            }
        }).orElse("");
    }

    public static Fn<Object, String> inBetween(String prefix, String suffix) {
        return Base.first(Strings.prepend(prefix)).then(Strings.append(suffix));
    }

    public static Fn<String, String> repeat(final int times) {
        return Base.when(Base.notNull, new Fn<String, String>(){

            @Override
            public String $(String s) {
                return Iterate.on(new Object[]{s}).repeat(times).join();
            }
        });
    }

    public static Fn<String, String> repeat(final int times, final String separator) {
        return Base.when(Base.notNull, new Fn<String, String>(){

            @Override
            public String $(String s) {
                return Iterate.on(new Object[]{s}).repeat(times).join(separator);
            }
        });
    }

    public static Fn<String, String> after(String substring) {
        if (substring == null || substring.isEmpty()) {
            return NOP.fn();
        }
        return Strings.from(Base.first(Strings.indexOf(substring)).then(Ints.add(substring.length())));
    }

    public static Fn<String, String> afterLast(String substring) {
        if (substring == null || substring.isEmpty()) {
            return Base.when(Base.notNull, Base.always(""));
        }
        return Strings.from(Base.first(Strings.lastIndexOf(substring)).then(Ints.add(substring.length())));
    }

    public static Fn<String, String> from(int index) {
        return Strings.from(Base.always(index));
    }

    public static Fn<String, String> from(final Fn<? super String, Integer> index) {
        return Base.when(Base.notNull, new Fn<String, String>(){

            @Override
            public String $(String s) {
                Integer idx = (Integer)index.$(s);
                if (idx == null) {
                    return null;
                }
                if (idx >= s.length()) {
                    return "";
                }
                return s.substring(idx);
            }
        });
    }

    public static Fn<String, String> before(String substring) {
        return substring == null ? NOP.fn() : Strings.before(Strings.indexOf(substring));
    }

    public static Fn<String, String> beforeLast(String substring) {
        return substring != null ? Strings.before(Strings.lastIndexOf(substring)) : NOP.fn();
    }

    public static Fn<String, String> before(int index) {
        return Strings.before(Base.always(index));
    }

    public static Fn<String, String> before(final Fn<? super String, Integer> index) {
        return Base.when(Base.notNull, new Fn<String, String>(){

            @Override
            public String $(String s) {
                Integer idx = (Integer)index.$(s);
                if (idx == null) {
                    return null;
                }
                if (idx >= s.length()) {
                    return s;
                }
                return s.substring(0, idx);
            }
        });
    }

    public static Fn<String, String> between(String openSubstring, String closeSubstring) {
        if (openSubstring == null || closeSubstring == null) {
            return Base.always(null);
        }
        return Base.first(Strings.after(openSubstring)).then(Strings.before(closeSubstring));
    }

    public static Fn<String, String> betweenOuter(String openSubstring, String closeSubstring) {
        if (openSubstring == null || closeSubstring == null) {
            return Base.always(null);
        }
        return Base.first(Strings.after(openSubstring)).then(Strings.beforeLast(closeSubstring));
    }

    public static Fn<String, Iterable<String>> allBetween(final String openSubstring, final String closeSubstring) {
        if (openSubstring == null || closeSubstring == null) {
            return Base.always(Collections.emptySet());
        }
        if ("".equals(openSubstring) && "".equals(closeSubstring)) {
            return Base.alwaysThrow(new IllegalArgumentException("Extracting all strings between two empty strings would yield an infinite amount of empty strings!"));
        }
        return Base.when(Base.notNull, new Fn<String, Iterable<String>>(){
            final Fn<String, String> firstSubstring;
            {
                this.firstSubstring = Strings.between(openSubstring, closeSubstring);
            }

            @Override
            public Iterable<String> $(String s) {
                Optional<String> original = Singular.optional(s);
                Mappable first = original.map(this.firstSubstring);
                if (!((Optional)first).isSome()) {
                    return Collections.emptySet();
                }
                Optional<String> rest = original.map(nonblank, Strings.after(((Optional)((Optional)first).map(Strings.inBetween(openSubstring, closeSubstring))).orElse(null)));
                return ((Optional)first).append(this.$(rest.orElse("")));
            }
        });
    }

    public static Fn<String, Integer> indexOf(final char c) {
        return Base.when(Base.notNull, new Fn<String, Integer>(){

            @Override
            public Integer $(String s) {
                int index = s.indexOf(c);
                return index >= 0 ? Integer.valueOf(index) : null;
            }
        });
    }

    public static Fn<String, Integer> lastIndexOf(final char c) {
        return Base.when(Base.notNull, new Fn<String, Integer>(){

            @Override
            public Integer $(String s) {
                int index = s.lastIndexOf(c);
                return index >= 0 ? Integer.valueOf(index) : null;
            }
        });
    }

    public static Fn<String, Integer> indexOf(final String substring) {
        if (substring == null) {
            return Base.always(null);
        }
        return Base.when(Base.notNull, new Fn<String, Integer>(){

            @Override
            public Integer $(String s) {
                int index = s.indexOf(substring);
                return index >= 0 ? Integer.valueOf(index) : null;
            }
        });
    }

    public static Fn<String, Integer> lastIndexOf(final String substring) {
        if (substring == null) {
            return Base.always(null);
        }
        return Base.when(Base.notNull, new Fn<String, Integer>(){

            @Override
            public Integer $(String s) {
                int index = s.lastIndexOf(substring);
                return index >= 0 ? Integer.valueOf(index) : null;
            }
        });
    }

    public static Fn<String, Iterable<String>> splittingOn(final String substring) {
        return new Fn<String, Iterable<String>>(){

            @Override
            public Iterable<String> $(String string) {
                return new SplitOnSubstring(string, substring);
            }
        };
    }

    public static Fn<String, Iterable<String>> splittingOn(char character) {
        return Strings.splittingOn(Base.equalTo(Character.valueOf(character)));
    }

    public static Fn<String, Iterable<String>> splittingOn(final Predicate<? super Character> character) {
        return new Fn<String, Iterable<String>>(){

            @Override
            public Iterable<String> $(String string) {
                return new SplitOnCharacter(string, character);
            }
        };
    }

    private Strings() {
    }
}

