/*
 * Decompiled with CFR 0.152.
 */
package no.motif.f.combine;

import java.util.Arrays;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.f.Predicate;
import no.motif.types.Appendable;

public class Disjunction<T>
implements Predicate<T> {
    private final Appendable<Predicate<? super T>> predicates;

    @SafeVarargs
    public Disjunction(Predicate<? super T> ... predicates) {
        this(Arrays.asList(predicates));
    }

    public Disjunction(Iterable<Predicate<? super T>> predicates) {
        this.predicates = Iterate.on(predicates);
    }

    @Override
    public boolean $(T value) {
        for (Predicate predicate : this.predicates) {
            if (!predicate.$(value)) continue;
            return true;
        }
        return false;
    }

    public Disjunction<T> or(T other) {
        return this.or(Base.equalTo(other));
    }

    public Disjunction<T> or(Predicate<? super T> otherPredicate) {
        return new Disjunction<T>(this.predicates.append(otherPredicate));
    }
}

