/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.f.Fn;
import no.motif.iter.EmptyIterator;
import no.motif.iter.ReadOnlyIterator;

class FlatMappingIterable<I, O>
implements Iterable<O>,
Serializable {
    private final Iterable<I> elements;
    private final Fn<? super I, ? extends Iterable<O>> fn;

    public FlatMappingIterable(Iterable<I> elements, Fn<? super I, ? extends Iterable<O>> fn) {
        this.elements = elements;
        this.fn = fn;
    }

    @Override
    public Iterator<O> iterator() {
        return new FlatMappingIterator();
    }

    private final class FlatMappingIterator
    extends ReadOnlyIterator<O> {
        Iterator<I> iterator;
        Iterator<O> mapped;

        private FlatMappingIterator() {
            this.iterator = FlatMappingIterable.this.elements.iterator();
            this.mapped = EmptyIterator.instance();
        }

        @Override
        public boolean hasNext() {
            if (!this.mapped.hasNext() && this.iterator.hasNext()) {
                this.mapped = ((Iterable)FlatMappingIterable.this.fn.$(this.iterator.next())).iterator();
            }
            return this.mapped.hasNext();
        }

        @Override
        public O next() {
            return this.mapped.next();
        }
    }
}

