/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Singular;
import no.motif.iter.SimpleIterator;
import no.motif.single.Optional;

class SkipLeadingIterable<T>
implements Iterable<T>,
Serializable {
    private final Iterable<T> elements;
    private final int toSkip;

    SkipLeadingIterable(int skip, Iterable<T> elements) {
        this.toSkip = skip;
        this.elements = elements;
    }

    @Override
    public Iterator<T> iterator() {
        return new SimpleIterator<T>(){
            Iterator<T> iterator;
            int skipped;
            {
                this.iterator = SkipLeadingIterable.this.elements.iterator();
                this.skipped = 0;
            }

            @Override
            protected Optional<T> nextIfAvailable() {
                if (!this.iterator.hasNext()) {
                    return Singular.none();
                }
                if (this.skipped == SkipLeadingIterable.this.toSkip) {
                    return Singular.optional(this.iterator.next());
                }
                this.iterator.next();
                ++this.skipped;
                return this.nextIfAvailable();
            }
        };
    }
}

