/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter;

import java.io.Serializable;
import java.util.Iterator;
import no.motif.Singular;
import no.motif.f.Fn;
import no.motif.iter.SimpleIterator;
import no.motif.single.Optional;

final class SuccessorIterable<T, F extends T>
implements Iterable<T>,
Serializable {
    private final Optional<F> firstElement;
    private final Fn<? super T, ? extends T> successor;

    SuccessorIterable(F firstElement, Fn<? super T, ? extends T> successor) {
        this.firstElement = Singular.optional(firstElement);
        this.successor = successor;
    }

    @Override
    public Iterator<T> iterator() {
        return new SimpleIterator<T>(){
            Optional<? extends T> next;
            {
                this.next = SuccessorIterable.this.firstElement;
            }

            @Override
            protected Optional<? extends T> nextIfAvailable() {
                Optional toReturn = this.next;
                this.next = this.next.map(SuccessorIterable.this.successor);
                return toReturn;
            }
        };
    }
}

