/*
 * Decompiled with CFR 0.152.
 */
package no.motif.iter.ordering;

import java.io.Serializable;
import java.util.Comparator;
import no.motif.Base;
import no.motif.f.Predicate;
import no.motif.iter.ordering.EnhancedComparator;
import no.motif.iter.ordering.OppositeOrderComparator;
import no.motif.iter.ordering.PrioritizingComparator;
import no.motif.iter.ordering.TwoNullsSafeComparator;

public class EnhancedComparatorImpl<T>
implements EnhancedComparator<T>,
Serializable {
    private final Comparator<T> comparator;

    public EnhancedComparatorImpl(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public int compare(T o1, T o2) {
        return this.comparator.compare(o1, o2);
    }

    @Override
    public EnhancedComparator<T> reversed() {
        return new EnhancedComparatorImpl<T>(new OppositeOrderComparator<T>(this.comparator));
    }

    @Override
    public EnhancedComparator<T> first(Predicate<? super T> prioritized) {
        return new EnhancedComparatorImpl<T>(new PrioritizingComparator<T>(this.comparator, prioritized));
    }

    @Override
    public EnhancedComparator<T> last(Predicate<? super T> last) {
        return this.first(Base.not(last));
    }

    @Override
    public EnhancedComparator<T> nullsFirst() {
        return new EnhancedComparatorImpl<Object>(new PrioritizingComparator<Object>(new TwoNullsSafeComparator<T>(this.comparator), Base.isNull));
    }

    @Override
    public EnhancedComparator<T> nullsLast() {
        return new EnhancedComparatorImpl<Object>(new PrioritizingComparator<Object>(new TwoNullsSafeComparator<T>(this.comparator), Base.notNull));
    }
}

