/*
 * Decompiled with CFR 0.152.
 */
package no.motif.maps;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.Maps;
import no.motif.f.Fn;

public class CombinedMapsView<K, I, V>
implements Map<K, V> {
    private final Map<K, I> m1;
    private final Map<I, V> m2;
    private final Fn<Map.Entry<K, I>, Map.Entry<K, V>> toEntry = new Fn<Map.Entry<K, I>, Map.Entry<K, V>>(){

        @Override
        public Map.Entry<K, V> $(Map.Entry<K, I> entry) {
            return new MapsViewEntry(entry.getKey(), entry.getValue());
        }
    };

    public CombinedMapsView(Map<K, I> m1, Map<I, V> m2) {
        this.m1 = m1;
        this.m2 = m2;
    }

    @Override
    public int size() {
        return Iterate.on(this.m1.values()).filter(Base.containedIn(this.m2.keySet())).collect().size();
    }

    @Override
    public boolean isEmpty() {
        return this.m1.isEmpty() || this.m2.isEmpty() || Iterate.on(this.m1).filter(Base.where(Maps.value(), Maps.keyIn(this.m2))).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m1.containsKey(key) && this.m2.containsKey(this.m1.get(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.m2.containsValue(value)) {
            Map.Entry entry = Iterate.on(this.m2).filter(Base.where(Maps.value(), Base.is(value))).head().get();
            return this.m1.containsValue(entry.getKey());
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (!this.m1.containsKey(key)) {
            return null;
        }
        return this.m2.get(this.m1.get(key));
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("put is not supported");
    }

    @Override
    public V remove(Object key) {
        if (this.containsKey(key)) {
            return this.m2.remove(this.m1.remove(key));
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("putAll is not supported");
    }

    @Override
    public void clear() {
        for (Map.Entry entry : Iterate.on(this.m1).filter(Base.where(Maps.value(), Maps.keyIn(this.m2))).eval()) {
            this.m1.remove(entry.getKey());
            this.m2.remove(entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return Iterate.on(this.m1).filter(Base.where(Maps.value(), Maps.keyIn(this.m2))).map(Maps.key()).collectIn(new LinkedHashSet());
    }

    @Override
    public Collection<V> values() {
        return Iterate.on(this.m2).filter(Base.where(Maps.key(), Maps.valueIn(this.m1))).map(Maps.value()).collect();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Iterate.on(this.m1).filter(Base.where(Maps.value(), Maps.keyIn(this.m2))).map(this.toEntry).collectIn(new LinkedHashSet());
    }

    private final class MapsViewEntry
    implements Map.Entry<K, V> {
        private final K key;
        private final I key2;

        public MapsViewEntry(K key, I key2) {
            this.key = key;
            this.key2 = key2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return CombinedMapsView.this.m2.get(this.key2);
        }

        @Override
        public V setValue(V value) {
            return CombinedMapsView.this.m2.put(this.key2, value);
        }
    }
}

