/*
 * Decompiled with CFR 0.152.
 */
package no.motif.single;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import no.motif.Base;
import no.motif.Iterate;
import no.motif.f.Fn;
import no.motif.f.Predicate;
import no.motif.iter.EmptyIterator;
import no.motif.iter.SingularIterator;
import no.motif.single.A;
import no.motif.types.Appendable;
import no.motif.types.Elements;
import no.motif.types.Filterable;
import no.motif.types.Mappable;
import no.motif.types.Prependable;

public abstract class Optional<V>
implements Iterable<V>,
Mappable<V>,
Filterable<V>,
Appendable<V>,
Prependable<V>,
Serializable {
    public static <V> Optional<V> resolve(Predicate<? super V> isPresent, V value) {
        if (isPresent.$(value)) {
            return Optional.some(value);
        }
        return None.getInstance();
    }

    public static <V> Some<V> some(V value) {
        return new Some(value);
    }

    public abstract V get();

    @Override
    public abstract <O> Optional<O> map(Fn<? super V, O> var1);

    public abstract <O> Optional<O> map(Predicate<? super O> var1, Fn<? super V, O> var2);

    public abstract <O> Optional<O> flatMap(Fn<? super V, Optional<O>> var1);

    @Override
    public abstract Optional<V> filter(Predicate<? super V> var1);

    public abstract boolean isSome();

    public abstract V orElse(V var1);

    public abstract V orNull();

    public abstract Optional<V> or(Optional<V> var1);

    public abstract <O> Elements<O> split(Fn<? super V, ? extends Iterable<O>> var1);

    @Override
    public Elements<V> append(Iterable<? extends V> trailingElements) {
        return Iterate.on(this).append(trailingElements);
    }

    @Override
    public Elements<V> append(V value) {
        return Iterate.on(this).append(value);
    }

    @Override
    public Elements<V> prepend(Iterable<? extends V> leadingElements) {
        return Iterate.on(this).prepend(leadingElements);
    }

    @Override
    public Elements<V> prepend(V value) {
        return Iterate.on(this).prepend(value);
    }

    private Optional() {
    }

    public static final class None<V>
    extends Optional<V> {
        private static final None<?> INSTANCE = new None();

        public static <V> None<V> getInstance() {
            return INSTANCE;
        }

        private None() {
        }

        @Override
        public V get() {
            throw new NoSuchElementException("Called get() on " + this);
        }

        @Override
        public final Iterator<V> iterator() {
            return EmptyIterator.instance();
        }

        @Override
        public final boolean isSome() {
            return false;
        }

        @Override
        public final V orElse(V fallback) {
            return fallback;
        }

        @Override
        public V orNull() {
            return null;
        }

        @Override
        public Optional<V> or(Optional<V> otherOptional) {
            return otherOptional;
        }

        @Override
        public <O> Optional<O> map(Fn<? super V, O> mapper) {
            return None.getInstance();
        }

        @Override
        public <O> Optional<O> map(Predicate<? super O> isPresent, Fn<? super V, O> mapper) {
            return None.getInstance();
        }

        @Override
        public <O> Optional<O> flatMap(Fn<? super V, Optional<O>> mapper) {
            return None.getInstance();
        }

        @Override
        public Optional<V> filter(Predicate<? super V> filter) {
            return None.getInstance();
        }

        @Override
        public <O> Elements<O> split(Fn<? super V, ? extends Iterable<O>> splitter) {
            return Iterate.none();
        }

        public String toString() {
            return "None";
        }

        private Object readResolve() {
            return None.getInstance();
        }

        public boolean equals(Object other) {
            return this == other || other instanceof None;
        }

        public int hashCode() {
            return 43;
        }
    }

    public static final class Some<V>
    extends Optional<V>
    implements A<V> {
        private final V value;

        private Some(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public final Iterator<V> iterator() {
            return new SingularIterator<V>(this.value);
        }

        @Override
        public final boolean isSome() {
            return true;
        }

        @Override
        public final V orElse(V fallback) {
            return this.get();
        }

        @Override
        public V orNull() {
            return this.value;
        }

        @Override
        public Optional<V> or(Optional<V> otherOptional) {
            return this;
        }

        @Override
        public <O> Optional<O> map(Fn<? super V, O> mapper) {
            O mapped = mapper.$(this.value);
            return Some.resolve(Base.notNull, mapped);
        }

        @Override
        public <O> Optional<O> map(Predicate<? super O> isPresent, Fn<? super V, O> mapper) {
            O mapped = mapper.$(this.value);
            return Some.resolve(isPresent, mapped);
        }

        @Override
        public <O> Optional<O> flatMap(Fn<? super V, Optional<O>> mapper) {
            return mapper.$(this.value);
        }

        @Override
        public Optional<V> filter(Predicate<? super V> accepted) {
            return Some.resolve(accepted, this.value);
        }

        @Override
        public <O> Elements<O> split(Fn<? super V, ? extends Iterable<O>> splitter) {
            return Iterate.on(splitter.$(this.value));
        }

        public boolean equals(Object o) {
            if (o instanceof Some) {
                Some other = (Some)o;
                return Objects.equals(this.value, other.value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public String toString() {
            return "Some(" + this.value + ")";
        }

        @Override
        public Optional<V> asOptional() {
            return this;
        }
    }
}

