/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache.fallback.disk;

import java.io.IOException;
import java.io.OutputStream;
import no.digipost.cache.fallback.FallbackKeeper;
import no.digipost.cache.fallback.disk.FallbackFile;
import no.digipost.cache.fallback.marshall.Marshaller;
import no.digipost.cache.function.ThrowingRunnable;

class DiskFallbackKeeper<K, V>
implements FallbackKeeper<K, V> {
    private FallbackFile.Resolver<K> fileResolver;
    private Marshaller<V> marshaller;

    public DiskFallbackKeeper(FallbackFile.Resolver<K> fileResolver, Marshaller<V> marshaller) {
        this.fileResolver = fileResolver;
        this.marshaller = marshaller;
    }

    @Override
    public void keep(K key, final V value) throws Exception {
        final FallbackFile fallbackFile = this.fileResolver.resolveFor(key);
        this.fileResolver.resolveFor(key).lock.runIfLock(new ThrowingRunnable<IOException>(){

            @Override
            public void run() throws IOException {
                try (OutputStream out = fallbackFile.write();){
                    DiskFallbackKeeper.this.marshaller.write(value, out);
                }
            }
        });
    }
}

