/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache.inmemory;

import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import no.digipost.cache.inmemory.CacheConfig;
import no.digipost.cache.inmemory.CacheStats;
import no.digipost.cache.inmemory.ConfiguresGuavaCache;
import no.digipost.cache.loader.Callables;
import no.digipost.cache.loader.Loader;
import no.motif.Iterate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cache<K, V> {
    static final Logger LOG = LoggerFactory.getLogger(Cache.class);
    private com.google.common.cache.Cache<K, V> guavaCache;
    private String name;

    public Cache(CacheConfig ... configurers) {
        this(Arrays.asList(configurers));
    }

    public Cache(String name, CacheConfig ... configurers) {
        this(name, Arrays.asList(configurers));
    }

    public Cache(Iterable<CacheConfig> configurers) {
        this("cache-" + UUID.randomUUID(), configurers);
    }

    public Cache(String name, Iterable<CacheConfig> configurers) {
        LOG.info("Creating new cache: {}", (Object)name);
        this.guavaCache = ((CacheBuilder)Iterate.on(configurers).append((Object)CacheConfig.jodaTicker).append((Object)CacheConfig.logRemoval).reduce((Object)CacheBuilder.newBuilder(), ConfiguresGuavaCache.applyConfiguration)).build();
        this.name = name;
    }

    public V get(K key, Callable<V> valueResolver) {
        return this.get(key, Callables.toLoader(valueResolver));
    }

    public V get(final K key, final Loader<? super K, V> valueResolver) {
        try {
            return (V)this.guavaCache.get(key, new Callable<V>(){

                @Override
                public V call() throws Exception {
                    LOG.debug("{} resolving value for key {}", (Object)Cache.this.name, key);
                    Object value = valueResolver.load(key);
                    LOG.info("Loaded '{}' into '{}' cache for key '{}'", new Object[]{value, Cache.this.name, key});
                    return value;
                }
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(this.getCauseDescription(cause), cause);
        }
        catch (ExecutionError e) {
            Throwable cause = e.getCause();
            throw new Error(this.getCauseDescription(cause), cause);
        }
    }

    private String getCauseDescription(Throwable cause) {
        return cause.getClass().getSimpleName() + ": " + cause.getMessage();
    }

    public void invalidateAll() {
        LOG.debug("Invalidating all in {} cache", (Object)this.name);
        this.guavaCache.invalidateAll();
    }

    @SafeVarargs
    public final void invalidate(K ... keys) {
        this.invalidate((Iterable<? extends K>)Arrays.asList(keys));
    }

    public void invalidate(Iterable<? extends K> keys) {
        LOG.debug("Invalidating specific keys in {} cache", (Object)this.name);
        this.guavaCache.invalidateAll(keys);
    }

    public CacheStats getCacheStats() {
        return CacheStats.fromGuava(this.guavaCache.stats());
    }
}

