/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.cache.inmemory;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import no.digipost.cache.inmemory.Cache;
import no.digipost.cache.inmemory.CacheConfig;
import no.digipost.cache.loader.Callables;
import no.digipost.cache.loader.Loader;
import no.motif.Iterate;

public final class SingleCached<V> {
    private final Cache<String, V> cache;
    private final Loader<? super String, V> resolver;
    private String key;

    public SingleCached(Callable<V> resolver, CacheConfig ... configs) {
        this(Callables.toLoader(resolver), configs);
    }

    public SingleCached(Loader<? super String, V> resolver, CacheConfig ... configs) {
        this(resolver, Arrays.asList(configs));
    }

    public SingleCached(String name, Callable<V> resolver, CacheConfig ... configs) {
        this(name, Callables.toLoader(resolver), configs);
    }

    public SingleCached(String name, Loader<? super String, V> resolver, CacheConfig ... configs) {
        this(name, resolver, Arrays.asList(configs));
    }

    public SingleCached(Callable<V> resolver, Iterable<CacheConfig> configs) {
        this(Callables.toLoader(resolver), configs);
    }

    public SingleCached(Loader<? super String, V> resolver, Iterable<CacheConfig> configs) {
        this("single-value-cache-" + UUID.randomUUID(), resolver, configs);
    }

    public SingleCached(String name, Callable<V> resolver, Iterable<CacheConfig> configs) {
        this(name, Callables.toLoader(resolver), configs);
    }

    public SingleCached(String name, Loader<? super String, V> resolver, Iterable<CacheConfig> configs) {
        this.resolver = resolver;
        this.cache = new Cache(name, (Iterable<CacheConfig>)Iterate.on(configs).append((Object)CacheConfig.initialCapacity(1)).append((Object)CacheConfig.maximumSize(1L)));
        this.key = name + "-cachekey";
    }

    public V get() {
        return this.cache.get(this.key, this.resolver);
    }

    public void invalidate() {
        this.cache.invalidateAll();
    }
}

