/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import no.digipost.print.validate.PdfValidator;
import org.apache.commons.lang3.StringUtils;

public enum PdfValidationError {
    PDF_IS_ENCRYPTED("The PDF document is encrypted."),
    TOO_MANY_PAGES_FOR_AUTOMATED_PRINT("The PDF document contains too many pages."),
    UNSUPPORTED_PDF_VERSION_FOR_PRINT("The version of the PDF document is not supported. Supported versions are " + StringUtils.join(PdfValidator.PDF_VERSIONS_SUPPORTED_FOR_PRINT, (String)", ") + "."),
    INSUFFICIENT_MARGIN_FOR_PRINT("The left margin of the PDF document is too narrow. Minimum left margin is 15 mm."),
    UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT("Could not verify the left margin of the PDF document. Minimum left margin is 15 mm."),
    PDF_PARSE_ERROR("Could not parse the PDF document."),
    PDF_PARSE_PAGE_ERROR("Could not parse at least one of the pages in the PDF document"),
    UNSUPPORTED_DIMENSIONS("The dimensions of the PDF document are not supported. Supported dimensions are width between %s\u2014%s mm and height between %s\u2014%s mm. If these limits should be changed, contact digipost support."),
    REFERENCES_INVALID_FONT("The document refers to a non-standard font that is not included in the PDF."),
    DOCUMENT_TOO_SMALL("The PDF document size is too small."),
    INVALID_PDF("The PDF document is invalid."),
    DOCUMENT_HAS_NO_PAGES("The PDF document does not contain any pages. The file may be corrupt.");

    static final Set<PdfValidationError> OK_FOR_PRINT;
    static final Set<PdfValidationError> OK_FOR_WEB;
    public final String message;

    private PdfValidationError(String message) {
        this.message = message;
    }

    public boolean isOkForWeb() {
        return OK_FOR_WEB.contains((Object)this);
    }

    public boolean isOkForPrint() {
        return OK_FOR_PRINT.contains((Object)this);
    }

    public String toString() {
        return this.message;
    }

    static {
        OK_FOR_PRINT = Collections.emptySet();
        OK_FOR_WEB = EnumSet.of(PDF_IS_ENCRYPTED, new PdfValidationError[]{TOO_MANY_PAGES_FOR_AUTOMATED_PRINT, UNSUPPORTED_PDF_VERSION_FOR_PRINT, INSUFFICIENT_MARGIN_FOR_PRINT, UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT, UNSUPPORTED_DIMENSIONS, PDF_PARSE_PAGE_ERROR});
    }
}

