/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.print.validate;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import no.digipost.print.validate.EnhancedNonSequentialPDFParser;
import no.digipost.print.validate.PdfFontValidator;
import no.digipost.print.validate.PdfValidateStrategy;
import no.digipost.print.validate.PdfValidationError;
import no.digipost.print.validate.PdfValidationResult;
import no.digipost.print.validate.PdfValidationSettings;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.PDFTextStripperByArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PdfValidator.class);
    private final PdfFontValidator fontValidator = new PdfFontValidator();
    private static final double MM_TO_POINTS = 2.8346457481384277;
    public static final int A4_HEIGHT_MM = 297;
    public static final int A4_WIDTH_MM = 210;
    public static final int BARCODE_AREA_WIDTH_MM = 15;
    public static final int BARCODE_AREA_HEIGHT_MM = 80;
    public static final int BARCODE_AREA_X_POS_MM = 0;
    public static final int BARCODE_AREA_Y_POS_MM = 95;
    public static final List<Float> PDF_VERSIONS_SUPPORTED_FOR_PRINT = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.1f), Float.valueOf(1.2f), Float.valueOf(1.3f), Float.valueOf(1.4f), Float.valueOf(1.5f), Float.valueOf(1.6f), Float.valueOf(1.7f));

    public PdfValidationResult validate(byte[] pdfContent, PdfValidationSettings printValidationSettings) {
        return this.validateForPrint(new ByteArrayInputStream(pdfContent), printValidationSettings, PdfValidateStrategy.FULLY_IN_MEMORY);
    }

    public PdfValidationResult validate(File pdfFile, PdfValidationSettings printValidationSettings) throws IOException {
        InputStream pdfStream = this.openFileAsInputStream(pdfFile);
        return this.validateForPrint(pdfStream, printValidationSettings, PdfValidateStrategy.FULLY_IN_MEMORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PdfValidationResult validateForPrint(InputStream pdfStream, PdfValidationSettings printValidationSettings, PdfValidateStrategy readStrategy) {
        int numberOfPages = -1;
        try {
            List<PdfValidationError> errors;
            block31: {
                try {
                    if (readStrategy == PdfValidateStrategy.NON_SEQUENTIALLY) {
                        try (EnhancedNonSequentialPDFParser dpostNonSequentialPDFParser = new EnhancedNonSequentialPDFParser(pdfStream);){
                            numberOfPages = dpostNonSequentialPDFParser.getNumberOfPages();
                            errors = this.validateStreamForPrint(dpostNonSequentialPDFParser, printValidationSettings);
                            break block31;
                        }
                    }
                    if (readStrategy == PdfValidateStrategy.FULLY_IN_MEMORY) {
                        try (PDDocument pdDoc = PDDocument.load((InputStream)pdfStream);){
                            numberOfPages = pdDoc.getNumberOfPages();
                            errors = this.validateDocumentForPrint(pdDoc, printValidationSettings);
                            break block31;
                        }
                    }
                    throw new IllegalArgumentException("Unknown " + PdfValidateStrategy.class.getSimpleName() + ": " + (Object)((Object)readStrategy));
                }
                catch (Exception e) {
                    errors = Arrays.asList(PdfValidationError.PDF_PARSE_ERROR);
                    LOG.info("PDF could not be parsed. (" + e.getMessage() + ")");
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
            PdfValidationResult pdfValidationResult = new PdfValidationResult(errors, numberOfPages, printValidationSettings.bleed);
            return pdfValidationResult;
        }
        finally {
            IOUtils.closeQuietly((InputStream)pdfStream);
        }
    }

    private List<PdfValidationError> validateStreamForPrint(EnhancedNonSequentialPDFParser dpostNonSequentialPDFParser, PdfValidationSettings settings) throws IOException {
        ArrayList<PdfValidationError> errors = new ArrayList<PdfValidationError>();
        if (dpostNonSequentialPDFParser.isEncrypted()) {
            return this.failValidationIfEncrypted(errors);
        }
        if (settings.validateNumberOfPages) {
            this.validerSideantall(dpostNonSequentialPDFParser.getNumberOfPages(), settings.maxNumberOfPages, errors);
        }
        if (settings.validatePDFversion) {
            this.validatePdfVersion(dpostNonSequentialPDFParser.getDocument().getVersion(), errors);
        }
        boolean documentHasInvalidDimensions = false;
        boolean documentContainsPagesWithInvalidPrintMargins = false;
        boolean documentHasInvalidLeftMargin = false;
        boolean documentHasPagesWhichCannotBeParsed = false;
        for (int i = 1; i <= dpostNonSequentialPDFParser.getNumberOfPages(); ++i) {
            PDPage page = null;
            try {
                page = dpostNonSequentialPDFParser.getPage(i);
            }
            catch (Exception e) {
                documentHasPagesWhichCannotBeParsed = true;
            }
            if (page != null) {
                if (!documentHasInvalidDimensions && this.hasInvalidDimensions(page, settings.bleed)) {
                    documentHasInvalidDimensions = true;
                }
                if (settings.validateLeftMargin && !documentHasInvalidLeftMargin) {
                    try {
                        if (this.hasTextInBarcodeArea(page, settings.bleed)) {
                            documentHasInvalidLeftMargin = true;
                        }
                    }
                    catch (NullPointerException npe) {
                        LOG.info("Could not verify margin on the following side " + i);
                        documentContainsPagesWithInvalidPrintMargins = true;
                    }
                }
                if (!settings.validateFonts) continue;
                this.validateFonts(this.fontValidator.getPageFonts(page), errors);
                continue;
            }
            LOG.warn("Could not fetch page {} in the pdf", (Object)i);
        }
        this.addValidationError(documentHasInvalidDimensions, PdfValidationError.UNSUPPORTED_DIMENSIONS, errors);
        this.addValidationError(documentHasInvalidLeftMargin, PdfValidationError.INSUFFICIENT_MARGIN_FOR_PRINT, errors);
        this.addValidationError(documentHasPagesWhichCannotBeParsed, PdfValidationError.PDF_PARSE_PAGE_ERROR, errors);
        this.addValidationError(documentContainsPagesWithInvalidPrintMargins, PdfValidationError.UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT, errors);
        return errors;
    }

    private List<PdfValidationError> validateDocumentForPrint(PDDocument pdDoc, PdfValidationSettings settings) throws IOException {
        ArrayList<PdfValidationError> errors = new ArrayList<PdfValidationError>();
        if (pdDoc.isEncrypted()) {
            return this.failValidationIfEncrypted(errors);
        }
        if (settings.validateNumberOfPages) {
            this.validerSideantall(pdDoc.getNumberOfPages(), settings.maxNumberOfPages, errors);
        }
        if (settings.validatePDFversion) {
            this.validatePdfVersion(pdDoc.getDocument().getVersion(), errors);
        }
        boolean documentHasInvalidDimensions = false;
        for (PDPage page : this.getAllPagesFrom(pdDoc)) {
            if (!this.hasInvalidDimensions(page, settings.bleed)) continue;
            documentHasInvalidDimensions = true;
            break;
        }
        this.addValidationError(documentHasInvalidDimensions, PdfValidationError.UNSUPPORTED_DIMENSIONS, errors);
        boolean hasTextInBarcodeArea = false;
        boolean documentContainsPagesWithInvalidPrintMargins = false;
        if (settings.validateLeftMargin) {
            for (PDPage page : this.getAllPagesFrom(pdDoc)) {
                try {
                    if (!this.hasTextInBarcodeArea(page, settings.bleed)) continue;
                    hasTextInBarcodeArea = true;
                    break;
                }
                catch (NullPointerException npe) {
                    documentContainsPagesWithInvalidPrintMargins = true;
                    LOG.info("Could not validate the margin on one of the sides");
                }
            }
        }
        this.addValidationError(documentContainsPagesWithInvalidPrintMargins, PdfValidationError.UNABLE_TO_VERIFY_SUITABLE_MARGIN_FOR_PRINT, errors);
        this.addValidationError(hasTextInBarcodeArea, PdfValidationError.INSUFFICIENT_MARGIN_FOR_PRINT, errors);
        if (settings.validateFonts) {
            for (PDPage page : this.getAllPagesFrom(pdDoc)) {
                this.validateFonts(this.fontValidator.getPageFonts(page), errors);
            }
        }
        return errors;
    }

    private void addValidationError(boolean documentContainsPagesThatCannotBeParsed, PdfValidationError validationErrors, List<PdfValidationError> errors) {
        if (documentContainsPagesThatCannotBeParsed) {
            errors.add(validationErrors);
        }
    }

    private List<PDPage> getAllPagesFrom(PDDocument pdDoc) {
        return pdDoc.getDocumentCatalog().getAllPages();
    }

    private List<PdfValidationError> failValidationIfEncrypted(List<PdfValidationError> errors) {
        errors.add(PdfValidationError.PDF_IS_ENCRYPTED);
        LOG.info("The pdf is encrypted.");
        return errors;
    }

    private void validateFonts(Iterable<PDFont> fonter, List<PdfValidationError> errors) {
        List<PDFont> nonSupportedFonts = this.fontValidator.findNonSupportedFonts(fonter);
        if (!nonSupportedFonts.isEmpty()) {
            errors.add(PdfValidationError.REFERENCES_INVALID_FONT);
            if (LOG.isInfoEnabled()) {
                LOG.info("The PDF has references to invalid fonts: [{}]", (Object)StringUtils.join(this.describe(nonSupportedFonts), (String)", "));
            }
        }
    }

    private List<String> describe(Iterable<PDFont> fonts) {
        ArrayList<String> fontDescriptions = new ArrayList<String>();
        for (PDFont font : fonts) {
            fontDescriptions.add(font.getSubType() + " '" + font.getBaseFont() + "'");
        }
        return fontDescriptions;
    }

    private void validatePdfVersion(float pdfVersion, List<PdfValidationError> errors) {
        if (!PDF_VERSIONS_SUPPORTED_FOR_PRINT.contains(Float.valueOf(pdfVersion))) {
            errors.add(PdfValidationError.UNSUPPORTED_PDF_VERSION_FOR_PRINT);
            LOG.info("The PDF is not in valid version. Valid versions are {}. Actual version is {}", (Object)StringUtils.join(PDF_VERSIONS_SUPPORTED_FOR_PRINT, (String)", "), (Object)Float.valueOf(pdfVersion));
        }
    }

    private void validerSideantall(int numberOfPages, int maxPages, List<PdfValidationError> errors) {
        if (numberOfPages > maxPages) {
            errors.add(PdfValidationError.TOO_MANY_PAGES_FOR_AUTOMATED_PRINT);
            LOG.info("The PDF has too many pages. Max number of pages is {}. Actual number of pages is {}", (Object)maxPages, (Object)numberOfPages);
        }
        if (numberOfPages == 0) {
            errors.add(PdfValidationError.DOCUMENT_HAS_NO_PAGES);
            LOG.info("The PDF document does not contain any pages. The file may be corrupt.", (Object)numberOfPages);
        }
    }

    private boolean hasTextInBarcodeArea(PDPage pdPage, PdfValidationSettings.Bleed bleed) throws IOException {
        SilentZone silentZone = new SilentZone(pdPage.findCropBox(), bleed);
        Rectangle2D.Double leftMarginBarcodeArea = new Rectangle2D.Double(silentZone.upperLeftCornerX, silentZone.upperLeftCornerY, silentZone.silentZoneXSize, silentZone.silentZoneYSize);
        return this.hasTextInArea(pdPage, leftMarginBarcodeArea);
    }

    private boolean hasInvalidDimensions(PDPage page, PdfValidationSettings.Bleed bleed) {
        PDRectangle findCropBox = page.findCropBox();
        long pageHeightInMillimeters = PdfValidator.pointsTomm(findCropBox.getHeight());
        long pageWidthInMillimeters = PdfValidator.pointsTomm(findCropBox.getWidth());
        if (!PdfValidator.isPortraitA4(pageWidthInMillimeters, pageHeightInMillimeters, bleed) && !PdfValidator.isLandscapeA4(pageWidthInMillimeters, pageHeightInMillimeters, bleed)) {
            LOG.info("One or more pages in the PDF has invalid dimensions.  Valid dimensions are width {} mm and height {} mm, alt width {} mm og height {} mm with {} mm lower flexibility and {} upper flexibility. Actual dimensions are width: {} mm and height: {} mm.", new Object[]{210, 297, 297, 210, bleed.negativeBleedInMM, bleed.positiveBleedInMM, pageWidthInMillimeters, pageHeightInMillimeters});
            return true;
        }
        return false;
    }

    private static boolean isPortraitA4(long pageWidthInMillimeters, long pageHeightInMillimeters, PdfValidationSettings.Bleed bleed) {
        long minimumWidth = 210 - bleed.negativeBleedInMM;
        long maximumWidth = 210 + bleed.positiveBleedInMM;
        long minimumHeight = 297 - bleed.negativeBleedInMM;
        long maximumHeight = 297 + bleed.positiveBleedInMM;
        return pageWidthInMillimeters <= maximumWidth && pageWidthInMillimeters >= minimumWidth && pageHeightInMillimeters <= maximumHeight && pageHeightInMillimeters >= minimumHeight;
    }

    private static boolean isLandscapeA4(long pageWidthInMillimeters, long pageHeightInMillimeters, PdfValidationSettings.Bleed bleed) {
        return PdfValidator.isPortraitA4(pageHeightInMillimeters, pageWidthInMillimeters, bleed);
    }

    private boolean hasTextInArea(PDPage pdPage, Rectangle2D area) throws IOException {
        boolean hasTextInArea = false;
        PDFTextStripperByArea stripper = new PDFTextStripperByArea();
        stripper.addRegion("marginArea", area);
        stripper.extractRegions(pdPage);
        String text = stripper.getTextForRegion("marginArea");
        if (text != null && text.trim().length() > 0) {
            hasTextInArea = true;
        }
        return hasTextInArea;
    }

    private InputStream openFileAsInputStream(File pdfFile) throws IOException {
        return new BufferedInputStream(Files.newInputStream(pdfFile.toPath(), new OpenOption[0]));
    }

    private static double mmToPoints(int sizeInMillimeters) {
        BigDecimal points = new BigDecimal((double)sizeInMillimeters * 2.8346457481384277);
        points = points.setScale(1, RoundingMode.DOWN);
        return points.doubleValue();
    }

    private static long pointsTomm(double sizeInPoints) {
        return Math.round(sizeInPoints / 2.8346457481384277);
    }

    private static class SilentZone {
        public final double upperLeftCornerX;
        public final double upperLeftCornerY;
        public final double silentZoneXSize;
        public final double silentZoneYSize;

        private SilentZone(PDRectangle findCropBox, PdfValidationSettings.Bleed bleed) {
            int pageHeightInMillimeters = (int)PdfValidator.pointsTomm(findCropBox.getHeight());
            int pageWidthInMillimeters = (int)PdfValidator.pointsTomm(findCropBox.getWidth());
            boolean isLandscape = PdfValidator.isLandscapeA4(pageWidthInMillimeters, pageHeightInMillimeters, bleed);
            this.upperLeftCornerX = this.upperLeftCornerX(isLandscape);
            this.upperLeftCornerY = this.upperLeftCornerY(isLandscape, pageHeightInMillimeters);
            this.silentZoneXSize = this.zoneXSize(isLandscape);
            this.silentZoneYSize = this.zoneYSize(isLandscape);
        }

        private double upperLeftCornerX(boolean isLandscape) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(95);
            }
            return PdfValidator.mmToPoints(0);
        }

        private double upperLeftCornerY(boolean isLandscape, int pageHeightInMillimeters) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(pageHeightInMillimeters - 15);
            }
            return PdfValidator.mmToPoints(95);
        }

        private double zoneXSize(boolean isLandscape) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(80);
            }
            return PdfValidator.mmToPoints(15);
        }

        private double zoneYSize(boolean isLandscape) {
            if (isLandscape) {
                return PdfValidator.mmToPoints(15);
            }
            return PdfValidator.mmToPoints(80);
        }
    }
}

