/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.http.client3;

import no.digipost.http.client3.DigipostHttpClientDefaults;
import no.digipost.http.client3.DigipostHttpClientMillisecondTimeouts;
import no.digipost.http.client3.DigipostHttpClientSettings;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class DigipostHttpClientFactory {
    public static CloseableHttpClient createDefault() {
        return DigipostHttpClientFactory.create(DigipostHttpClientSettings.DEFAULT);
    }

    public static CloseableHttpClient create(DigipostHttpClientSettings settings) {
        return DigipostHttpClientFactory.createBuilder(settings).build();
    }

    public static HttpClientBuilder createDefaultBuilder() {
        return DigipostHttpClientFactory.createBuilder(DigipostHttpClientSettings.DEFAULT);
    }

    public static HttpClientBuilder createBuilder(DigipostHttpClientSettings settings) {
        if (settings.timeoutsMs.isPotentiallyDangerous()) {
            settings.logger.warn("New http client with potential dangerous settings. These settings should probably not be used in production:\n{}", (Object)settings);
        } else {
            settings.logger.info("New http client:\n{}", (Object)settings);
        }
        return HttpClientBuilder.create().setDefaultConnectionConfig(settings.connectionConfig).setDefaultSocketConfig(DigipostHttpClientFactory.createSocketConfig(settings.timeoutsMs)).setDefaultRequestConfig(DigipostHttpClientFactory.createRequestConfig(settings.timeoutsMs)).setMaxConnTotal(settings.connectionAmount.maxTotal).setMaxConnPerRoute(settings.connectionAmount.maxPerRoute).setProxy(settings.httpProxy);
    }

    public static RequestConfig createDefaultRequestConfig() {
        return DigipostHttpClientFactory.createRequestConfig(DigipostHttpClientDefaults.DEFAULT_TIMEOUTS_MS);
    }

    public static RequestConfig createRequestConfig(DigipostHttpClientMillisecondTimeouts timeoutsMs) {
        return RequestConfig.custom().setConnectionRequestTimeout(timeoutsMs.connectionRequest).setConnectTimeout(timeoutsMs.connect).setSocketTimeout(timeoutsMs.socket).build();
    }

    public static SocketConfig createDefaultSocketConfig() {
        return DigipostHttpClientFactory.createSocketConfig(DigipostHttpClientDefaults.DEFAULT_TIMEOUTS_MS);
    }

    public static SocketConfig createSocketConfig(DigipostHttpClientMillisecondTimeouts timeoutsMs) {
        return SocketConfig.custom().setSoTimeout(timeoutsMs.socket).build();
    }

    public static ConnectionConfig createDefaultConnectionConfig() {
        return ConnectionConfig.DEFAULT;
    }

    private DigipostHttpClientFactory() {
    }
}

