/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.http.client3;

import no.digipost.http.client3.Validation;

public final class DigipostHttpClientMillisecondTimeouts {
    public final int socket;
    public final int connect;
    public final int connectionRequest;

    DigipostHttpClientMillisecondTimeouts(int socket, int connect, int connectionRequest) {
        this.socket = Validation.equalOrGreater(socket, 0, "socket timeout");
        this.connect = Validation.equalOrGreater(connect, 0, "connect timeout");
        this.connectionRequest = Validation.equalOrGreater(connectionRequest, 0, "connection request timeout");
    }

    public DigipostHttpClientMillisecondTimeouts all(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(timeoutMs, timeoutMs, timeoutMs);
    }

    public DigipostHttpClientMillisecondTimeouts socket(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(timeoutMs, this.connect, this.connectionRequest);
    }

    public DigipostHttpClientMillisecondTimeouts connect(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(this.socket, timeoutMs, this.connectionRequest);
    }

    public DigipostHttpClientMillisecondTimeouts connectionRequest(int timeoutMs) {
        return new DigipostHttpClientMillisecondTimeouts(this.socket, this.connect, timeoutMs);
    }

    boolean isPotentiallyDangerous() {
        return this.socket == 0 || this.connect == 0 || this.connectionRequest == 0;
    }
}

