/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Address;

@XmlType
public final class Bruker {
    @XmlElement(name="fornavn", required=true)
    @NotNull
    @Description(value="")
    private final String navn;
    @XmlElement(name="etternavn", required=true)
    @NotNull
    @Description(value="")
    private final String etternavn;
    @XmlElement(name="foedselsnummer")
    @Pattern(regexp="[0-9]{11}")
    @Description(value="")
    private final @Pattern(regexp="[0-9]{11}") String foedselsnummer;
    @XmlElement(name="adresse")
    @Description(value="")
    private final Address adresse;
    public static Bruker EXAMPLE = new Bruker("Ola", "Nordmann", null, Address.EXAMPLE);

    public String getNavn() {
        return this.navn;
    }

    public String getEtternavn() {
        return this.etternavn;
    }

    public String getFoedselsnummer() {
        return this.foedselsnummer;
    }

    public Address getAdresse() {
        return this.adresse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bruker)) {
            return false;
        }
        Bruker other = (Bruker)o;
        String this$navn = this.getNavn();
        String other$navn = other.getNavn();
        if (this$navn == null ? other$navn != null : !this$navn.equals(other$navn)) {
            return false;
        }
        String this$etternavn = this.getEtternavn();
        String other$etternavn = other.getEtternavn();
        if (this$etternavn == null ? other$etternavn != null : !this$etternavn.equals(other$etternavn)) {
            return false;
        }
        String this$foedselsnummer = this.getFoedselsnummer();
        String other$foedselsnummer = other.getFoedselsnummer();
        if (this$foedselsnummer == null ? other$foedselsnummer != null : !this$foedselsnummer.equals(other$foedselsnummer)) {
            return false;
        }
        Address this$adresse = this.getAdresse();
        Address other$adresse = other.getAdresse();
        return !(this$adresse == null ? other$adresse != null : !((Object)this$adresse).equals(other$adresse));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $navn = this.getNavn();
        result = result * 59 + ($navn == null ? 43 : $navn.hashCode());
        String $etternavn = this.getEtternavn();
        result = result * 59 + ($etternavn == null ? 43 : $etternavn.hashCode());
        String $foedselsnummer = this.getFoedselsnummer();
        result = result * 59 + ($foedselsnummer == null ? 43 : $foedselsnummer.hashCode());
        Address $adresse = this.getAdresse();
        result = result * 59 + ($adresse == null ? 43 : ((Object)$adresse).hashCode());
        return result;
    }

    public String toString() {
        return "Bruker(navn=" + this.getNavn() + ", etternavn=" + this.getEtternavn() + ", foedselsnummer=" + this.getFoedselsnummer() + ", adresse=" + this.getAdresse() + ")";
    }

    @ConstructorProperties(value={"navn", "etternavn", "foedselsnummer", "adresse"})
    public Bruker(String navn, String etternavn, String foedselsnummer, Address adresse) {
        this.navn = navn;
        this.etternavn = etternavn;
        this.foedselsnummer = foedselsnummer;
        this.adresse = adresse;
    }

    private Bruker() {
        this.navn = null;
        this.etternavn = null;
        this.foedselsnummer = null;
        this.adresse = null;
    }

    public Bruker withNavn(String navn) {
        return this.navn == navn ? this : new Bruker(navn, this.etternavn, this.foedselsnummer, this.adresse);
    }

    public Bruker withEtternavn(String etternavn) {
        return this.etternavn == etternavn ? this : new Bruker(this.navn, etternavn, this.foedselsnummer, this.adresse);
    }

    public Bruker withFoedselsnummer(String foedselsnummer) {
        return this.foedselsnummer == foedselsnummer ? this : new Bruker(this.navn, this.etternavn, foedselsnummer, this.adresse);
    }

    public Bruker withAdresse(Address adresse) {
        return this.adresse == adresse ? this : new Bruker(this.navn, this.etternavn, this.foedselsnummer, adresse);
    }
}

