/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.receipt;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.receipt.VatDetails;

@XmlType
@Description(value="Details for taxi receipts")
public final class TaxiDetails {
    @XmlElement
    private final String carPlateNumber;
    @XmlElement
    private final String license;
    @XmlElement
    private final String orgNumberLicenseHolder;
    @XmlElement
    private final ZonedDateTime startTime;
    @XmlElement
    private final ZonedDateTime stopTime;
    @XmlElement
    private final BigDecimal tips;
    @XmlElement
    private final BigDecimal totalMeterPrice;
    @XmlElement
    private final Integer totalDistanceBeforeBoardingInMeters;
    @XmlElement
    private final Integer totalDistanceInMeters;
    @XmlElement
    private final Integer totalDistanceWithPassengerInMeters;
    @XmlElement
    private final Integer totalTimeBeforeBoardingInSeconds;
    @XmlElement
    private final Integer totalTimeInSeconds;
    @XmlElement
    private final Integer totalTimeWithPassengerInSeconds;
    @Valid
    private final VatDetails vat;
    public static final TaxiDetails EXAMPLE = new TaxiDetails("EK99999", "12341ASDF", "123456789", ZonedDateTime.of(2018, 6, 5, 10, 0, 0, 0, ZoneId.systemDefault()), ZonedDateTime.of(2018, 6, 5, 10, 30, 0, 0, ZoneId.systemDefault()), new BigDecimal("8.00"), new BigDecimal("438.50"), 2000, 8500, 6500, 320, 1220, 900, VatDetails.EXAMPLE);

    public String getCarPlateNumber() {
        return this.carPlateNumber;
    }

    public String getLicense() {
        return this.license;
    }

    public String getOrgNumberLicenseHolder() {
        return this.orgNumberLicenseHolder;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public ZonedDateTime getStopTime() {
        return this.stopTime;
    }

    public BigDecimal getTips() {
        return this.tips;
    }

    public BigDecimal getTotalMeterPrice() {
        return this.totalMeterPrice;
    }

    public Integer getTotalDistanceBeforeBoardingInMeters() {
        return this.totalDistanceBeforeBoardingInMeters;
    }

    public Integer getTotalDistanceInMeters() {
        return this.totalDistanceInMeters;
    }

    public Integer getTotalDistanceWithPassengerInMeters() {
        return this.totalDistanceWithPassengerInMeters;
    }

    public Integer getTotalTimeBeforeBoardingInSeconds() {
        return this.totalTimeBeforeBoardingInSeconds;
    }

    public Integer getTotalTimeInSeconds() {
        return this.totalTimeInSeconds;
    }

    public Integer getTotalTimeWithPassengerInSeconds() {
        return this.totalTimeWithPassengerInSeconds;
    }

    public VatDetails getVat() {
        return this.vat;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxiDetails)) {
            return false;
        }
        TaxiDetails other = (TaxiDetails)o;
        String this$carPlateNumber = this.getCarPlateNumber();
        String other$carPlateNumber = other.getCarPlateNumber();
        if (this$carPlateNumber == null ? other$carPlateNumber != null : !this$carPlateNumber.equals(other$carPlateNumber)) {
            return false;
        }
        String this$license = this.getLicense();
        String other$license = other.getLicense();
        if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
            return false;
        }
        String this$orgNumberLicenseHolder = this.getOrgNumberLicenseHolder();
        String other$orgNumberLicenseHolder = other.getOrgNumberLicenseHolder();
        if (this$orgNumberLicenseHolder == null ? other$orgNumberLicenseHolder != null : !this$orgNumberLicenseHolder.equals(other$orgNumberLicenseHolder)) {
            return false;
        }
        ZonedDateTime this$startTime = this.getStartTime();
        ZonedDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        ZonedDateTime this$stopTime = this.getStopTime();
        ZonedDateTime other$stopTime = other.getStopTime();
        if (this$stopTime == null ? other$stopTime != null : !((Object)this$stopTime).equals(other$stopTime)) {
            return false;
        }
        BigDecimal this$tips = this.getTips();
        BigDecimal other$tips = other.getTips();
        if (this$tips == null ? other$tips != null : !((Object)this$tips).equals(other$tips)) {
            return false;
        }
        BigDecimal this$totalMeterPrice = this.getTotalMeterPrice();
        BigDecimal other$totalMeterPrice = other.getTotalMeterPrice();
        if (this$totalMeterPrice == null ? other$totalMeterPrice != null : !((Object)this$totalMeterPrice).equals(other$totalMeterPrice)) {
            return false;
        }
        Integer this$totalDistanceBeforeBoardingInMeters = this.getTotalDistanceBeforeBoardingInMeters();
        Integer other$totalDistanceBeforeBoardingInMeters = other.getTotalDistanceBeforeBoardingInMeters();
        if (this$totalDistanceBeforeBoardingInMeters == null ? other$totalDistanceBeforeBoardingInMeters != null : !((Object)this$totalDistanceBeforeBoardingInMeters).equals(other$totalDistanceBeforeBoardingInMeters)) {
            return false;
        }
        Integer this$totalDistanceInMeters = this.getTotalDistanceInMeters();
        Integer other$totalDistanceInMeters = other.getTotalDistanceInMeters();
        if (this$totalDistanceInMeters == null ? other$totalDistanceInMeters != null : !((Object)this$totalDistanceInMeters).equals(other$totalDistanceInMeters)) {
            return false;
        }
        Integer this$totalDistanceWithPassengerInMeters = this.getTotalDistanceWithPassengerInMeters();
        Integer other$totalDistanceWithPassengerInMeters = other.getTotalDistanceWithPassengerInMeters();
        if (this$totalDistanceWithPassengerInMeters == null ? other$totalDistanceWithPassengerInMeters != null : !((Object)this$totalDistanceWithPassengerInMeters).equals(other$totalDistanceWithPassengerInMeters)) {
            return false;
        }
        Integer this$totalTimeBeforeBoardingInSeconds = this.getTotalTimeBeforeBoardingInSeconds();
        Integer other$totalTimeBeforeBoardingInSeconds = other.getTotalTimeBeforeBoardingInSeconds();
        if (this$totalTimeBeforeBoardingInSeconds == null ? other$totalTimeBeforeBoardingInSeconds != null : !((Object)this$totalTimeBeforeBoardingInSeconds).equals(other$totalTimeBeforeBoardingInSeconds)) {
            return false;
        }
        Integer this$totalTimeInSeconds = this.getTotalTimeInSeconds();
        Integer other$totalTimeInSeconds = other.getTotalTimeInSeconds();
        if (this$totalTimeInSeconds == null ? other$totalTimeInSeconds != null : !((Object)this$totalTimeInSeconds).equals(other$totalTimeInSeconds)) {
            return false;
        }
        Integer this$totalTimeWithPassengerInSeconds = this.getTotalTimeWithPassengerInSeconds();
        Integer other$totalTimeWithPassengerInSeconds = other.getTotalTimeWithPassengerInSeconds();
        if (this$totalTimeWithPassengerInSeconds == null ? other$totalTimeWithPassengerInSeconds != null : !((Object)this$totalTimeWithPassengerInSeconds).equals(other$totalTimeWithPassengerInSeconds)) {
            return false;
        }
        VatDetails this$vat = this.getVat();
        VatDetails other$vat = other.getVat();
        return !(this$vat == null ? other$vat != null : !((Object)this$vat).equals(other$vat));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $carPlateNumber = this.getCarPlateNumber();
        result = result * 59 + ($carPlateNumber == null ? 43 : $carPlateNumber.hashCode());
        String $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : $license.hashCode());
        String $orgNumberLicenseHolder = this.getOrgNumberLicenseHolder();
        result = result * 59 + ($orgNumberLicenseHolder == null ? 43 : $orgNumberLicenseHolder.hashCode());
        ZonedDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        ZonedDateTime $stopTime = this.getStopTime();
        result = result * 59 + ($stopTime == null ? 43 : ((Object)$stopTime).hashCode());
        BigDecimal $tips = this.getTips();
        result = result * 59 + ($tips == null ? 43 : ((Object)$tips).hashCode());
        BigDecimal $totalMeterPrice = this.getTotalMeterPrice();
        result = result * 59 + ($totalMeterPrice == null ? 43 : ((Object)$totalMeterPrice).hashCode());
        Integer $totalDistanceBeforeBoardingInMeters = this.getTotalDistanceBeforeBoardingInMeters();
        result = result * 59 + ($totalDistanceBeforeBoardingInMeters == null ? 43 : ((Object)$totalDistanceBeforeBoardingInMeters).hashCode());
        Integer $totalDistanceInMeters = this.getTotalDistanceInMeters();
        result = result * 59 + ($totalDistanceInMeters == null ? 43 : ((Object)$totalDistanceInMeters).hashCode());
        Integer $totalDistanceWithPassengerInMeters = this.getTotalDistanceWithPassengerInMeters();
        result = result * 59 + ($totalDistanceWithPassengerInMeters == null ? 43 : ((Object)$totalDistanceWithPassengerInMeters).hashCode());
        Integer $totalTimeBeforeBoardingInSeconds = this.getTotalTimeBeforeBoardingInSeconds();
        result = result * 59 + ($totalTimeBeforeBoardingInSeconds == null ? 43 : ((Object)$totalTimeBeforeBoardingInSeconds).hashCode());
        Integer $totalTimeInSeconds = this.getTotalTimeInSeconds();
        result = result * 59 + ($totalTimeInSeconds == null ? 43 : ((Object)$totalTimeInSeconds).hashCode());
        Integer $totalTimeWithPassengerInSeconds = this.getTotalTimeWithPassengerInSeconds();
        result = result * 59 + ($totalTimeWithPassengerInSeconds == null ? 43 : ((Object)$totalTimeWithPassengerInSeconds).hashCode());
        VatDetails $vat = this.getVat();
        result = result * 59 + ($vat == null ? 43 : ((Object)$vat).hashCode());
        return result;
    }

    public String toString() {
        return "TaxiDetails(carPlateNumber=" + this.getCarPlateNumber() + ", license=" + this.getLicense() + ", orgNumberLicenseHolder=" + this.getOrgNumberLicenseHolder() + ", startTime=" + this.getStartTime() + ", stopTime=" + this.getStopTime() + ", tips=" + this.getTips() + ", totalMeterPrice=" + this.getTotalMeterPrice() + ", totalDistanceBeforeBoardingInMeters=" + this.getTotalDistanceBeforeBoardingInMeters() + ", totalDistanceInMeters=" + this.getTotalDistanceInMeters() + ", totalDistanceWithPassengerInMeters=" + this.getTotalDistanceWithPassengerInMeters() + ", totalTimeBeforeBoardingInSeconds=" + this.getTotalTimeBeforeBoardingInSeconds() + ", totalTimeInSeconds=" + this.getTotalTimeInSeconds() + ", totalTimeWithPassengerInSeconds=" + this.getTotalTimeWithPassengerInSeconds() + ", vat=" + this.getVat() + ")";
    }

    @ConstructorProperties(value={"carPlateNumber", "license", "orgNumberLicenseHolder", "startTime", "stopTime", "tips", "totalMeterPrice", "totalDistanceBeforeBoardingInMeters", "totalDistanceInMeters", "totalDistanceWithPassengerInMeters", "totalTimeBeforeBoardingInSeconds", "totalTimeInSeconds", "totalTimeWithPassengerInSeconds", "vat"})
    public TaxiDetails(String carPlateNumber, String license, String orgNumberLicenseHolder, ZonedDateTime startTime, ZonedDateTime stopTime, BigDecimal tips, BigDecimal totalMeterPrice, Integer totalDistanceBeforeBoardingInMeters, Integer totalDistanceInMeters, Integer totalDistanceWithPassengerInMeters, Integer totalTimeBeforeBoardingInSeconds, Integer totalTimeInSeconds, Integer totalTimeWithPassengerInSeconds, VatDetails vat) {
        this.carPlateNumber = carPlateNumber;
        this.license = license;
        this.orgNumberLicenseHolder = orgNumberLicenseHolder;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.tips = tips;
        this.totalMeterPrice = totalMeterPrice;
        this.totalDistanceBeforeBoardingInMeters = totalDistanceBeforeBoardingInMeters;
        this.totalDistanceInMeters = totalDistanceInMeters;
        this.totalDistanceWithPassengerInMeters = totalDistanceWithPassengerInMeters;
        this.totalTimeBeforeBoardingInSeconds = totalTimeBeforeBoardingInSeconds;
        this.totalTimeInSeconds = totalTimeInSeconds;
        this.totalTimeWithPassengerInSeconds = totalTimeWithPassengerInSeconds;
        this.vat = vat;
    }

    private TaxiDetails() {
        this.carPlateNumber = null;
        this.license = null;
        this.orgNumberLicenseHolder = null;
        this.startTime = null;
        this.stopTime = null;
        this.tips = null;
        this.totalMeterPrice = null;
        this.totalDistanceBeforeBoardingInMeters = null;
        this.totalDistanceInMeters = null;
        this.totalDistanceWithPassengerInMeters = null;
        this.totalTimeBeforeBoardingInSeconds = null;
        this.totalTimeInSeconds = null;
        this.totalTimeWithPassengerInSeconds = null;
        this.vat = null;
    }

    public TaxiDetails withCarPlateNumber(String carPlateNumber) {
        return this.carPlateNumber == carPlateNumber ? this : new TaxiDetails(carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withLicense(String license) {
        return this.license == license ? this : new TaxiDetails(this.carPlateNumber, license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withOrgNumberLicenseHolder(String orgNumberLicenseHolder) {
        return this.orgNumberLicenseHolder == orgNumberLicenseHolder ? this : new TaxiDetails(this.carPlateNumber, this.license, orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withStartTime(ZonedDateTime startTime) {
        return this.startTime == startTime ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withStopTime(ZonedDateTime stopTime) {
        return this.stopTime == stopTime ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTips(BigDecimal tips) {
        return this.tips == tips ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTotalMeterPrice(BigDecimal totalMeterPrice) {
        return this.totalMeterPrice == totalMeterPrice ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTotalDistanceBeforeBoardingInMeters(Integer totalDistanceBeforeBoardingInMeters) {
        return this.totalDistanceBeforeBoardingInMeters == totalDistanceBeforeBoardingInMeters ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTotalDistanceInMeters(Integer totalDistanceInMeters) {
        return this.totalDistanceInMeters == totalDistanceInMeters ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTotalDistanceWithPassengerInMeters(Integer totalDistanceWithPassengerInMeters) {
        return this.totalDistanceWithPassengerInMeters == totalDistanceWithPassengerInMeters ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTotalTimeBeforeBoardingInSeconds(Integer totalTimeBeforeBoardingInSeconds) {
        return this.totalTimeBeforeBoardingInSeconds == totalTimeBeforeBoardingInSeconds ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTotalTimeInSeconds(Integer totalTimeInSeconds) {
        return this.totalTimeInSeconds == totalTimeInSeconds ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withTotalTimeWithPassengerInSeconds(Integer totalTimeWithPassengerInSeconds) {
        return this.totalTimeWithPassengerInSeconds == totalTimeWithPassengerInSeconds ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, totalTimeWithPassengerInSeconds, this.vat);
    }

    public TaxiDetails withVat(VatDetails vat) {
        return this.vat == vat ? this : new TaxiDetails(this.carPlateNumber, this.license, this.orgNumberLicenseHolder, this.startTime, this.stopTime, this.tips, this.totalMeterPrice, this.totalDistanceBeforeBoardingInMeters, this.totalDistanceInMeters, this.totalDistanceWithPassengerInMeters, this.totalTimeBeforeBoardingInSeconds, this.totalTimeInSeconds, this.totalTimeWithPassengerInSeconds, vat);
    }
}

