/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.documentation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;
import no.digipost.api.datatypes.DataType;
import no.digipost.api.datatypes.DataTypeIdentifier;
import no.digipost.api.datatypes.documentation.ComplexType;
import no.digipost.api.datatypes.documentation.DocumentationStructureBuilder;
import no.digipost.api.datatypes.documentation.MarkdownPrinter;
import no.digipost.api.datatypes.marshalling.DataTypesJAXBContext;

public class DocumentationGenerator {
    public static void main(String[] args) throws IOException, JAXBException {
        Path outputPath = Paths.get(args[0], new String[0]);
        DocumentationGenerator.generate(outputPath, DataTypeIdentifier.getAllClasses(), DocumentationGenerator::getDataTypeExample);
    }

    public static DataType getDataTypeExample(Class<? extends DataType> dataType) {
        return DataTypeIdentifier.fromRepresentationType(dataType).getExample();
    }

    private static <T> void generate(Path outputPath, Set<Class<? extends T>> typesToDocument, Function<Class<? extends T>, T> getExample) throws IOException, JAXBException {
        Stream<ComplexType> types = DocumentationStructureBuilder.buildTypeStructure(typesToDocument, getExample);
        String markdown = new MarkdownPrinter(DataTypesJAXBContext.getSingleton(), false).print(types.collect(Collectors.toList()));
        Files.write(outputPath, markdown.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

