/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.marshalling;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class ZonedDateTimeXmlAdapter
extends XmlAdapter<String, ZonedDateTime> {
    public String marshal(ZonedDateTime v) {
        if (v == null) {
            return null;
        }
        return DatatypeConverter.printDateTime((Calendar)GregorianCalendar.from(v));
    }

    public ZonedDateTime unmarshal(String s) {
        if (s == null) {
            return null;
        }
        return ZonedDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(s)).withZoneSameInstant(ZoneId.systemDefault());
    }
}

