/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;

@XmlType
public final class TimeInterval {
    @XmlElement(name="start-time", required=true)
    @NotNull
    @Description(value="ISO8601 full DateTime")
    private final ZonedDateTime startTime;
    @XmlElement(name="end-time", required=true)
    @Description(value="ISO8601 full DateTime")
    private final ZonedDateTime endTime;
    public static TimeInterval EXAMPLE = new TimeInterval(ZonedDateTime.of(2019, 5, 23, 10, 0, 0, 0, ZoneId.systemDefault()), ZonedDateTime.of(2019, 5, 23, 16, 0, 0, 0, ZoneId.systemDefault()));

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public ZonedDateTime getEndTime() {
        return this.endTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeInterval)) {
            return false;
        }
        TimeInterval other = (TimeInterval)o;
        ZonedDateTime this$startTime = this.getStartTime();
        ZonedDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        ZonedDateTime this$endTime = this.getEndTime();
        ZonedDateTime other$endTime = other.getEndTime();
        return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        ZonedDateTime $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        return result;
    }

    public String toString() {
        return "TimeInterval(startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
    }

    @ConstructorProperties(value={"startTime", "endTime"})
    public TimeInterval(ZonedDateTime startTime, ZonedDateTime endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    private TimeInterval() {
        this.startTime = null;
        this.endTime = null;
    }

    public TimeInterval withStartTime(ZonedDateTime startTime) {
        return this.startTime == startTime ? this : new TimeInterval(startTime, this.endTime);
    }

    public TimeInterval withEndTime(ZonedDateTime endTime) {
        return this.endTime == endTime ? this : new TimeInterval(this.startTime, endTime);
    }
}

