/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.pickup;

import java.beans.ConstructorProperties;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.Address;

@XmlType
public final class Recipient {
    @XmlElement(name="name", required=true)
    @Description(value="The name of the recipient")
    private final String name;
    @XmlElement(name="digipost-address", required=true)
    @Description(value="The digipost address for the recipient")
    private final String digipostAddress;
    @XmlElement
    private final Address address;
    public static final Recipient EXAMPLE = new Recipient("Test Testesen", "test.testesen#0000", Address.EXAMPLE);

    public String getName() {
        return this.name;
    }

    public String getDigipostAddress() {
        return this.digipostAddress;
    }

    public Address getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recipient)) {
            return false;
        }
        Recipient other = (Recipient)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$digipostAddress = this.getDigipostAddress();
        String other$digipostAddress = other.getDigipostAddress();
        if (this$digipostAddress == null ? other$digipostAddress != null : !this$digipostAddress.equals(other$digipostAddress)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $digipostAddress = this.getDigipostAddress();
        result = result * 59 + ($digipostAddress == null ? 43 : $digipostAddress.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    public String toString() {
        return "Recipient(name=" + this.getName() + ", digipostAddress=" + this.getDigipostAddress() + ", address=" + this.getAddress() + ")";
    }

    @ConstructorProperties(value={"name", "digipostAddress", "address"})
    public Recipient(String name, String digipostAddress, Address address) {
        this.name = name;
        this.digipostAddress = digipostAddress;
        this.address = address;
    }

    private Recipient() {
        this.name = null;
        this.digipostAddress = null;
        this.address = null;
    }

    public Recipient withName(String name) {
        return this.name == name ? this : new Recipient(name, this.digipostAddress, this.address);
    }

    public Recipient withDigipostAddress(String digipostAddress) {
        return this.digipostAddress == digipostAddress ? this : new Recipient(this.name, digipostAddress, this.address);
    }

    public Recipient withAddress(Address address) {
        return this.address == address ? this : new Recipient(this.name, this.digipostAddress, address);
    }
}

