/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.api.datatypes.types.proof;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import no.digipost.api.datatypes.documentation.Description;
import no.digipost.api.datatypes.types.proof.TidsPeriode;
import no.digipost.api.datatypes.validation.ValidPeriode;

@XmlType
@ValidPeriode
public final class Periode
implements TidsPeriode {
    @XmlElement(name="fra")
    @Description(value="ISO8601 full DateTime")
    private final ZonedDateTime fra;
    @XmlElement(name="til")
    @Description(value="ISO8601 full DateTime")
    private final ZonedDateTime til;
    public static Periode EXAMPLE = new Periode(ZonedDateTime.of(2019, 5, 23, 10, 0, 0, 0, ZoneId.systemDefault()), ZonedDateTime.of(2019, 5, 23, 16, 0, 0, 0, ZoneId.systemDefault()));

    public ZonedDateTime getFra() {
        return this.fra;
    }

    public ZonedDateTime getTil() {
        return this.til;
    }

    public String toString() {
        return "Periode(fra=" + this.getFra() + ", til=" + this.getTil() + ")";
    }

    @ConstructorProperties(value={"fra", "til"})
    public Periode(ZonedDateTime fra, ZonedDateTime til) {
        this.fra = fra;
        this.til = til;
    }

    private Periode() {
        this.fra = null;
        this.til = null;
    }

    public Periode withFra(ZonedDateTime fra) {
        return this.fra == fra ? this : new Periode(fra, this.til);
    }

    public Periode withTil(ZonedDateTime til) {
        return this.til == til ? this : new Periode(this.fra, til);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Periode)) {
            return false;
        }
        Periode other = (Periode)o;
        ZonedDateTime this$fra = this.getFra();
        ZonedDateTime other$fra = other.getFra();
        if (this$fra == null ? other$fra != null : !((Object)this$fra).equals(other$fra)) {
            return false;
        }
        ZonedDateTime this$til = this.getTil();
        ZonedDateTime other$til = other.getTil();
        return !(this$til == null ? other$til != null : !((Object)this$til).equals(other$til));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $fra = this.getFra();
        result = result * 59 + ($fra == null ? 43 : ((Object)$fra).hashCode());
        ZonedDateTime $til = this.getTil();
        result = result * 59 + ($til == null ? 43 : ((Object)$til).hashCode());
        return result;
    }
}

